/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultProjectDependencyGraph
implements ProjectDependencyGraph {
    private ProjectSorter sorter;

    public DefaultProjectDependencyGraph(ProjectSorter sorter) {
        if (sorter == null) {
            throw new IllegalArgumentException("project sorter missing");
        }
        this.sorter = sorter;
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        if (project == null) {
            throw new IllegalArgumentException("project missing");
        }
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependents(projectId)) {
            projectIds.add(id);
            if (!transitive) continue;
            this.getDownstreamProjects(id, projectIds, transitive);
        }
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        if (project == null) {
            throw new IllegalArgumentException("project missing");
        }
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependencies(projectId)) {
            projectIds.add(id);
            if (!transitive) continue;
            this.getUpstreamProjects(id, projectIds, transitive);
        }
    }

    private List<MavenProject> getProjects(Collection<String> projectIds) {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        for (MavenProject p : this.sorter.getSortedProjects()) {
            if (!projectIds.contains(ProjectSorter.getId(p))) continue;
            projects.add(p);
        }
        return projects;
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }
}

