/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.classrealm;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.classrealm.ArtifactClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.apache.maven.classrealm.DefaultClassRealmRequest;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ClassRealmManager.class)
public class DefaultClassRealmManager
implements ClassRealmManager {
    @Requirement
    private Logger logger;
    @Requirement
    protected PlexusContainer container;

    private ClassWorld getClassWorld() {
        return ((MutablePlexusContainer)this.container).getClassWorld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassRealm createRealm(String baseRealmId, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> imports, boolean importXpp3Dom, List<Artifact> artifacts) {
        ClassRealm classRealm;
        ClassWorld world;
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                artifactIds.add(artifact.getId());
                if (artifact.getFile() == null) continue;
                constituents.add(new ArtifactClassRealmConstituent(artifact));
            }
        }
        imports = imports != null ? new ArrayList<String>(imports) : new ArrayList<String>();
        DefaultClassRealmRequest request = new DefaultClassRealmRequest(type, parent, imports, constituents);
        ClassWorld classWorld = world = this.getClassWorld();
        synchronized (classWorld) {
            String realmId = baseRealmId;
            Random random = new Random();
            while (true) {
                try {
                    classRealm = world.newRealm(realmId, null);
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("Created new class realm " + realmId);
                }
                catch (DuplicateRealmException e) {
                    realmId = baseRealmId + '-' + random.nextInt();
                    continue;
                }
                break;
            }
        }
        if (parent != null) {
            classRealm.setParentClassLoader(parent);
        } else {
            classRealm.setParentRealm(this.getCoreRealm());
            this.importMavenApi(classRealm);
        }
        for (ClassRealmManagerDelegate delegate : this.getDelegates()) {
            delegate.setupRealm(classRealm, request);
        }
        if (importXpp3Dom) {
            this.importXpp3Dom(classRealm);
        }
        if (!imports.isEmpty()) {
            ClassLoader importedRealm = classRealm.getParentClassLoader();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing packages into class realm " + classRealm.getId());
            }
            for (String imp : imports) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  Imported: " + imp);
                }
                classRealm.importFrom(importedRealm, imp);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Populating class realm " + classRealm.getId());
        }
        for (ClassRealmConstituent constituent : constituents) {
            File file = constituent.getFile();
            String id = DefaultClassRealmManager.getId(constituent);
            artifactIds.remove(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Included: " + id);
            }
            try {
                classRealm.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        if (this.logger.isDebugEnabled()) {
            for (String id : artifactIds) {
                this.logger.debug("  Excluded: " + id);
            }
        }
        return classRealm;
    }

    private void importXpp3Dom(ClassRealm importingRealm) {
        ClassRealm coreRealm = this.getCoreRealm();
        importingRealm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.xml.Xpp3Dom");
        importingRealm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.xml.pull.XmlPullParser");
        importingRealm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.xml.pull.XmlPullParserException");
        importingRealm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.xml.pull.XmlSerializer");
    }

    private void importMavenApi(ClassRealm importingRealm) {
        importingRealm.importFromParent("org.apache.maven");
        importingRealm.importFromParent("org.codehaus.plexus.classworlds");
        importingRealm.importFromParent("org.codehaus.classworlds");
        importingRealm.importFromParent("org.codehaus.plexus.component");
        importingRealm.importFromParent("org.codehaus.plexus.configuration");
        importingRealm.importFromParent("org.codehaus.plexus.container");
        importingRealm.importFromParent("org.codehaus.plexus.context");
        importingRealm.importFromParent("org.codehaus.plexus.lifecycle");
        importingRealm.importFromParent("org.codehaus.plexus.logging");
        importingRealm.importFromParent("org.codehaus.plexus.personality");
        importingRealm.importFromParent("org.codehaus.plexus.ComponentRegistry");
        importingRealm.importFromParent("org.codehaus.plexus.ContainerConfiguration");
        importingRealm.importFromParent("org.codehaus.plexus.DefaultComponentRegistry");
        importingRealm.importFromParent("org.codehaus.plexus.DefaultContainerConfiguration");
        importingRealm.importFromParent("org.codehaus.plexus.DefaultPlexusContainer");
        importingRealm.importFromParent("org.codehaus.plexus.DuplicateChildContainerException");
        importingRealm.importFromParent("org.codehaus.plexus.MutablePlexusContainer");
        importingRealm.importFromParent("org.codehaus.plexus.PlexusConstants");
        importingRealm.importFromParent("org.codehaus.plexus.PlexusContainer");
        importingRealm.importFromParent("org.codehaus.plexus.PlexusContainerException");
    }

    @Override
    public ClassRealm getCoreRealm() {
        return this.container.getContainerRealm();
    }

    @Override
    public ClassRealm createProjectRealm(Model model, List<Artifact> artifacts) {
        if (model == null) {
            throw new IllegalArgumentException("model missing");
        }
        return this.createRealm(DefaultClassRealmManager.getKey(model), ClassRealmRequest.RealmType.Project, null, null, false, artifacts);
    }

    private static String getKey(Model model) {
        return "project>" + model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    @Override
    public ClassRealm createExtensionRealm(Plugin plugin, List<Artifact> artifacts) {
        if (plugin == null) {
            throw new IllegalArgumentException("extension plugin missing");
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, true), ClassRealmRequest.RealmType.Extension, null, null, true, artifacts);
    }

    @Override
    public ClassRealm createPluginRealm(Plugin plugin, ClassLoader parent, List<String> imports, List<Artifact> artifacts) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin missing");
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, false), ClassRealmRequest.RealmType.Plugin, parent, imports, true, artifacts);
    }

    private static String getKey(Plugin plugin, boolean extension) {
        String version = ArtifactUtils.toSnapshotVersion((String)plugin.getVersion());
        return (extension ? "extension>" : "plugin>") + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + version;
    }

    private static String getId(ClassRealmConstituent constituent) {
        return constituent.getGroupId() + ':' + constituent.getArtifactId() + ':' + constituent.getType() + (StringUtils.isNotEmpty((String)constituent.getClassifier()) ? ':' + constituent.getClassifier() : "") + ':' + constituent.getVersion();
    }

    private List<ClassRealmManagerDelegate> getDelegates() {
        try {
            return this.container.lookupList(ClassRealmManagerDelegate.class);
        }
        catch (ComponentLookupException e) {
            return Collections.emptyList();
        }
    }
}

