/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SettingsAdapter
extends Settings {
    private MavenExecutionRequest request;
    private RuntimeInfo runtimeInfo;

    public SettingsAdapter(MavenExecutionRequest request) {
        this.request = request;
        this.runtimeInfo = new RuntimeInfo(request.getUserSettingsFile());
    }

    public String getLocalRepository() {
        if (this.request.getLocalRepositoryPath() != null) {
            return this.request.getLocalRepositoryPath().getAbsolutePath();
        }
        return null;
    }

    public boolean isInteractiveMode() {
        return this.request.isInteractiveMode();
    }

    public boolean isOffline() {
        return this.request.isOffline();
    }

    public List<Proxy> getProxies() {
        return this.request.getProxies();
    }

    public List<Server> getServers() {
        return this.request.getServers();
    }

    public List<Mirror> getMirrors() {
        return this.request.getMirrors();
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>();
    }

    public List<String> getActiveProfiles() {
        return this.request.getActiveProfiles();
    }

    public List<String> getPluginGroups() {
        return this.request.getPluginGroups();
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }
}

