/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.NoGoalSpecifiedException;
import org.apache.maven.lifecycle.internal.BuildListCalculator;
import org.apache.maven.lifecycle.internal.ConcurrencyDependencyGraph;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.LifecycleThreadedBuilder;
import org.apache.maven.lifecycle.internal.LifecycleWeaveBuilder;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.ThreadConfigurationService;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleExecutor.class)
public class DefaultLifecycleExecutor
implements LifecycleExecutor {
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private LifeCyclePluginAnalyzer lifeCyclePluginAnalyzer;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private Logger logger;
    @Requirement
    private LifecycleModuleBuilder lifecycleModuleBuilder;
    @Requirement
    private LifecycleWeaveBuilder lifeCycleWeaveBuilder;
    @Requirement
    private LifecycleThreadedBuilder lifecycleThreadedBuilder;
    @Requirement
    private BuildListCalculator buildListCalculator;
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    @Requirement
    private LifecycleExecutionPlanCalculator lifecycleExecutionPlanCalculator;
    @Requirement
    private ThreadConfigurationService threadConfigService;
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MavenSession session) {
        block11: {
            this.eventCatapult.fire(ExecutionEvent.Type.SessionStarted, session, null);
            MavenExecutionResult result = session.getResult();
            try {
                if (!session.isUsingPOMsFromFilesystem() && this.lifecycleTaskSegmentCalculator.requiresProject(session)) {
                    throw new MissingProjectException("The goal you specified requires a project to execute but there is no POM in this directory (" + session.getExecutionRootDirectory() + ")." + " Please verify you invoked Maven from the correct directory.");
                }
                MavenExecutionRequest executionRequest = session.getRequest();
                boolean isThreaded = executionRequest.isThreadConfigurationPresent();
                session.setParallel(isThreaded);
                List<TaskSegment> taskSegments = this.buildListCalculator.calculateTaskSegments(session);
                ProjectBuildList projectBuilds = this.buildListCalculator.calculateProjectBuilds(session, taskSegments);
                if (projectBuilds.isEmpty()) {
                    throw new NoGoalSpecifiedException("No goals have been specified for this build. You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + ".");
                }
                ProjectIndex projectIndex = new ProjectIndex(session.getProjects());
                if (this.logger.isDebugEnabled()) {
                    this.lifecycleDebugLogger.debugReactorPlan(projectBuilds);
                }
                ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
                ReactorBuildStatus reactorBuildStatus = new ReactorBuildStatus(session.getProjectDependencyGraph());
                ReactorContext callableContext = new ReactorContext(result, projectIndex, oldContextClassLoader, reactorBuildStatus);
                if (isThreaded) {
                    ExecutorService executor = this.threadConfigService.getExecutorService(executionRequest.getThreadCount(), executionRequest.isPerCoreThreadCount(), session.getProjects().size());
                    try {
                        boolean isWeaveMode = LifecycleWeaveBuilder.isWeaveMode(executionRequest);
                        if (isWeaveMode) {
                            this.lifecycleDebugLogger.logWeavePlan(session);
                            ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
                            this.lifeCycleWeaveBuilder.build(projectBuilds, callableContext, taskSegments, session, service, reactorBuildStatus);
                        } else {
                            ConcurrencyDependencyGraph analyzer = new ConcurrencyDependencyGraph(projectBuilds, session.getProjectDependencyGraph());
                            ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
                            this.lifecycleThreadedBuilder.build(session, callableContext, projectBuilds, taskSegments, analyzer, service);
                        }
                        break block11;
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                this.singleThreadedBuild(session, callableContext, projectBuilds, taskSegments, reactorBuildStatus);
            }
            catch (Exception e) {
                result.addException(e);
            }
        }
        this.eventCatapult.fire(ExecutionEvent.Type.SessionEnded, session, null);
    }

    private void singleThreadedBuild(MavenSession session, ReactorContext callableContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) {
        block2: for (TaskSegment taskSegment : taskSegments) {
            for (ProjectSegment projectBuild : projectBuilds.getByTaskSegment(taskSegment)) {
                try {
                    this.lifecycleModuleBuilder.buildProject(session, callableContext, projectBuild.getProject(), taskSegment);
                    if (!reactorBuildStatus.isHalted()) continue;
                }
                catch (Exception e) {}
                continue block2;
            }
        }
    }

    @Override
    public Set<Plugin> getPluginsBoundByDefaultToAllLifecycles(String packaging) {
        return this.lifeCyclePluginAnalyzer.getPluginsBoundByDefaultToAllLifecycles(packaging);
    }

    @Deprecated
    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        return this.defaultLifeCycles.getPhaseToLifecycleMap();
    }

    MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project, String invokedVia, boolean canUsePrefix, boolean isOptionalMojo) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        return this.mojoDescriptorCreator.getMojoDescriptor(task, session, project);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, String ... tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginManagerException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        List<TaskSegment> taskSegments = this.buildListCalculator.calculateTaskSegments(session);
        TaskSegment mergedSegment = new TaskSegment(false);
        for (TaskSegment taskSegment : taskSegments) {
            mergedSegment.getTasks().addAll(taskSegment.getTasks());
        }
        return this.lifecycleExecutionPlanCalculator.calculateExecutionPlan(session, session.getCurrentProject(), mergedSegment.getTasks());
    }
}

