/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.Schedule;
import org.apache.maven.lifecycle.Scheduling;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchedules {
    List<Scheduling> schedules;

    public DefaultSchedules() {
    }

    public DefaultSchedules(List<Scheduling> schedules) {
        this.schedules = schedules;
    }

    public List<ExecutionPlanItem> createExecutionPlanItem(MavenProject mavenProject, List<MojoExecution> executions) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        BuilderCommon.attachToThread(mavenProject);
        ArrayList<ExecutionPlanItem> result = new ArrayList<ExecutionPlanItem>();
        for (MojoExecution mojoExecution : executions) {
            String lifeCyclePhase = mojoExecution.getMojoDescriptor().getPhase();
            Scheduling scheduling = this.getScheduling("default");
            Schedule schedule = null;
            if (scheduling != null && (schedule = scheduling.getSchedule(mojoExecution.getPlugin())) == null) {
                schedule = scheduling.getSchedule(lifeCyclePhase);
            }
            result.add(new ExecutionPlanItem(mojoExecution, schedule));
        }
        return result;
    }

    Scheduling getScheduling(String lifecyclePhaseName) {
        for (Scheduling schedule : this.schedules) {
            if (!lifecyclePhaseName.equals(schedule.getLifecycle())) continue;
            return schedule;
        }
        return null;
    }

    public List<Scheduling> getSchedules() {
        return this.schedules;
    }
}

