/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=BuildListCalculator.class)
public class BuildListCalculator {
    @Requirement
    private LifecycleTaskSegmentCalculator lifeCycleTaskSegmentCalculator;

    public BuildListCalculator() {
    }

    public BuildListCalculator(LifecycleTaskSegmentCalculator lifeCycleTaskSegmentCalculator) {
        this.lifeCycleTaskSegmentCalculator = lifeCycleTaskSegmentCalculator;
    }

    public List<TaskSegment> calculateTaskSegments(MavenSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException {
        MavenProject rootProject = session.getTopLevelProject();
        List<String> tasks = session.getGoals();
        if ((tasks == null || tasks.isEmpty()) && !StringUtils.isEmpty((String)rootProject.getDefaultGoal())) {
            tasks = Arrays.asList(StringUtils.split((String)rootProject.getDefaultGoal()));
        }
        return this.lifeCycleTaskSegmentCalculator.calculateTaskSegments(session, tasks);
    }

    public ProjectBuildList calculateProjectBuilds(MavenSession session, List<TaskSegment> taskSegments) {
        ArrayList<ProjectSegment> projectBuilds = new ArrayList<ProjectSegment>();
        MavenProject rootProject = session.getTopLevelProject();
        for (TaskSegment taskSegment : taskSegments) {
            List<MavenProject> projects = taskSegment.isAggregating() ? Collections.singletonList(rootProject) : session.getProjects();
            for (MavenProject project : projects) {
                BuilderCommon.attachToThread(project);
                MavenSession copiedSession = session.clone();
                copiedSession.setCurrentProject(project);
                projectBuilds.add(new ProjectSegment(project, taskSegment, copiedSession));
            }
        }
        return new ProjectBuildList(projectBuilds);
    }
}

