/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.lifecycle.internal.BuildLogItem;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.project.MavenProject;

public class ConcurrentBuildLogger {
    private final long startTime;
    private final Map<MavenProject, Thread> threadMap = new ConcurrentHashMap<MavenProject, Thread>();
    List<BuildLogItem> items = Collections.synchronizedList(new ArrayList());

    public ConcurrentBuildLogger() {
        this.startTime = System.currentTimeMillis();
    }

    public BuildLogItem createBuildLogItem(MavenProject project, ExecutionPlanItem current) {
        this.threadMap.put(project, Thread.currentThread());
        BuildLogItem result = new BuildLogItem(project, current);
        this.items.add(result);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<MavenProject, Thread> mavenProjectThreadEntry : this.threadMap.entrySet()) {
            result.append(mavenProjectThreadEntry.getKey().getName());
            result.append(" ran on ");
            result.append(mavenProjectThreadEntry.getValue().getName());
            result.append("\n");
        }
        for (BuildLogItem builtLogItem : this.items) {
            result.append(builtLogItem.toString(this.startTime));
            result.append("\n");
        }
        return result.toString();
    }

    public String toGraph() {
        StringBuilder result = new StringBuilder();
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (BuildLogItem builtLogItem : this.items) {
            multiMap.put((Object)builtLogItem.getProject(), (Object)builtLogItem);
        }
        result.append("digraph build");
        result.append(" {\n ");
        for (MavenProject mavenProject : multiMap.keySet()) {
            Collection builtLogItems = multiMap.get((Object)mavenProject);
            result.append("   subgraph ");
            result.append(mavenProject.getArtifactId());
            result.append("   {\n");
            for (BuildLogItem builtLogItem : builtLogItems) {
                result.append(builtLogItem.toGraph(this.startTime));
            }
            result.append("\n   }\n");
        }
        result.append("\n}\n ");
        return result.toString();
    }
}

