/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyContext {
    private final Collection<String> scopesToCollect;
    private final Collection<String> scopesToResolve;
    private final boolean aggregating;
    private volatile MavenProject lastProject;
    private volatile Collection<?> lastDependencyArtifacts;
    private volatile int lastDependencyArtifactCount;

    private DependencyContext(Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating) {
        this.scopesToCollect = scopesToCollect;
        this.scopesToResolve = scopesToResolve;
        this.aggregating = aggregating;
    }

    public DependencyContext(MavenExecutionPlan executionPlan, boolean aggregating) {
        this(executionPlan.getRequiredCollectionScopes(), executionPlan.getRequiredResolutionScopes(), aggregating);
    }

    public void setLastDependencyArtifacts(Collection<?> lastDependencyArtifacts) {
        this.lastDependencyArtifacts = lastDependencyArtifacts;
        this.lastDependencyArtifactCount = lastDependencyArtifacts != null ? lastDependencyArtifacts.size() : 0;
    }

    public MavenProject getLastProject() {
        return this.lastProject;
    }

    public void setLastProject(MavenProject lastProject) {
        this.lastProject = lastProject;
    }

    public Collection<String> getScopesToCollect() {
        return this.scopesToCollect;
    }

    public Collection<String> getScopesToResolve() {
        return this.scopesToResolve;
    }

    public boolean isAggregating() {
        return this.aggregating;
    }

    public DependencyContext clone() {
        return new DependencyContext(this.scopesToCollect, this.scopesToResolve, this.aggregating);
    }

    public boolean isSameProject(MavenSession session) {
        return this.lastProject == session.getCurrentProject();
    }

    public boolean isSameButUpdatedProject(MavenSession session) {
        return this.isSameProject(session) && (this.lastDependencyArtifacts != this.lastProject.getDependencyArtifacts() || this.lastDependencyArtifacts != null && this.lastDependencyArtifactCount != this.lastDependencyArtifacts.size());
    }
}

