/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.lifecycle.Schedule;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;

public class ExecutionPlanItem {
    private final MojoExecution mojoExecution;
    private final Schedule schedule;
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Object monitor = new Object();

    public ExecutionPlanItem(MojoExecution mojoExecution, Schedule schedule) {
        this.mojoExecution = mojoExecution;
        this.schedule = schedule;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public String getLifecyclePhase() {
        return this.mojoExecution.getLifecyclePhase();
    }

    public void setComplete() {
        boolean transitionSuccessful = this.ensureComplete();
        if (!transitionSuccessful) {
            throw new IllegalStateException("Expected to be able to setComplete node, but was complete already");
        }
    }

    public boolean ensureComplete() {
        boolean f = this.complete.compareAndSet(false, true);
        this.notifyListeners();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    public void forceComplete() {
        boolean b = this.complete.getAndSet(true);
        if (!b) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            while (!this.complete.get()) {
                this.monitor.wait(100L);
            }
        }
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Plugin getPlugin() {
        MojoDescriptor mojoDescriptor = this.getMojoExecution().getMojoDescriptor();
        return mojoDescriptor.getPluginDescriptor().getPlugin();
    }

    public String toString() {
        return "ExecutionPlanItem{, mojoExecution=" + this.mojoExecution + ", schedule=" + this.schedule + '}' + super.toString();
    }
}

