/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecyclePluginAnalyzerImpl.class)
public class LifecyclePluginAnalyzerImpl
implements LifeCyclePluginAnalyzer {
    @Requirement
    private Map<String, LifecycleMapping> lifecycleMappings;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private Logger logger;

    @Override
    public Set<Plugin> getPluginsBoundByDefaultToAllLifecycles(String packaging) {
        LifecycleMapping lifecycleMappingForPackaging;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up lifecyle mappings for packaging " + packaging + " from " + Thread.currentThread().getContextClassLoader());
        }
        if ((lifecycleMappingForPackaging = this.lifecycleMappings.get(packaging)) == null) {
            return null;
        }
        LinkedHashMap<Plugin, Plugin> plugins = new LinkedHashMap<Plugin, Plugin>();
        for (Lifecycle lifecycle : this.defaultLifeCycles.getLifeCycles()) {
            org.apache.maven.lifecycle.mapping.Lifecycle lifecycleConfiguration = lifecycleMappingForPackaging.getLifecycles().get(lifecycle.getId());
            Map<String, String> phaseToGoalMapping = null;
            if (lifecycleConfiguration != null) {
                phaseToGoalMapping = lifecycleConfiguration.getPhases();
            } else if (lifecycle.getDefaultPhases() != null) {
                phaseToGoalMapping = lifecycle.getDefaultPhases();
            }
            if (phaseToGoalMapping == null) continue;
            for (Map.Entry<String, String> goalsForLifecyclePhase : phaseToGoalMapping.entrySet()) {
                String phase = goalsForLifecyclePhase.getKey();
                String goals = goalsForLifecyclePhase.getValue();
                if (goals == null) continue;
                this.parseLifecyclePhaseDefinitions(plugins, phase, goals);
            }
        }
        return plugins.keySet();
    }

    private void parseLifecyclePhaseDefinitions(Map<Plugin, Plugin> plugins, String phase, String goals) {
        String[] mojos = StringUtils.split((String)goals, (String)",");
        for (int i = 0; i < mojos.length; ++i) {
            Plugin existing;
            String goal = mojos[i].trim();
            String[] p = StringUtils.split((String)goal, (String)":");
            PluginExecution execution = new PluginExecution();
            execution.setId("default-" + p[p.length - 1]);
            execution.setPhase(phase);
            execution.setPriority(i - mojos.length);
            execution.getGoals().add(p[p.length - 1]);
            Plugin plugin = new Plugin();
            plugin.setGroupId(p[0]);
            plugin.setArtifactId(p[1]);
            if (p.length >= 4) {
                plugin.setVersion(p[2]);
            }
            if ((existing = plugins.get(plugin)) != null) {
                if (existing.getVersion() == null) {
                    existing.setVersion(plugin.getVersion());
                }
                plugin = existing;
            } else {
                plugins.put(plugin, plugin);
            }
            plugin.getExecutions().add(execution);
        }
    }
}

