/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.Schedule;
import org.apache.maven.lifecycle.internal.BuildLogItem;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.ConcurrentBuildLogger;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.PhaseRecorder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.ThreadOutputMuxer;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleWeaveBuilder.class)
public class LifecycleWeaveBuilder {
    @Requirement
    private MojoExecutor mojoExecutor;
    @Requirement
    private BuilderCommon builderCommon;
    @Requirement
    private Logger logger;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    private Map<MavenProject, MavenExecutionPlan> executionPlans = new HashMap<MavenProject, MavenExecutionPlan>();

    public LifecycleWeaveBuilder() {
    }

    public LifecycleWeaveBuilder(MojoExecutor mojoExecutor, BuilderCommon builderCommon, Logger logger, ExecutionEventCatapult eventCatapult) {
        this.mojoExecutor = mojoExecutor;
        this.builderCommon = builderCommon;
        this.logger = logger;
        this.eventCatapult = eventCatapult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(ProjectBuildList projectBuilds, ReactorContext buildContext, List<TaskSegment> taskSegments, MavenSession session, CompletionService<ProjectSegment> service, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        ConcurrentBuildLogger concurrentBuildLogger = new ConcurrentBuildLogger();
        try {
            ArrayList<Future<ProjectSegment>> futures = new ArrayList<Future<ProjectSegment>>();
            for (TaskSegment taskSegment : taskSegments) {
                ProjectBuildList segmentChunks = projectBuilds.getByTaskSegment(taskSegment);
                ThreadOutputMuxer muxer = null;
                HashSet<String> projectArtifacts = new HashSet<String>();
                HashSet<Artifact> projectArtifactsA = new HashSet<Artifact>();
                for (ProjectSegment projectSegment : segmentChunks) {
                    Artifact artifact = projectSegment.getProject().getArtifact();
                    if (artifact == null) continue;
                    projectArtifacts.add(ArtifactUtils.key((Artifact)artifact));
                    projectArtifactsA.add(artifact);
                }
                for (ProjectSegment projectSegment : segmentChunks) {
                    try {
                        MavenExecutionPlan executionPlan = this.builderCommon.resolveBuildPlan(projectSegment.getSession(), projectSegment.getProject(), projectSegment.getTaskSegment(), projectArtifactsA);
                        for (Artifact dependency : projectSegment.getProject().getDependencyArtifacts()) {
                            String s = ArtifactUtils.key((Artifact)dependency);
                            if (!projectArtifacts.contains(s)) continue;
                            dependency.setFile(null);
                            dependency.setResolved(false);
                            dependency.setRepository(null);
                        }
                        this.executionPlans.put(projectSegment.getProject(), executionPlan);
                        DependencyContext dependencyContext = new DependencyContext(executionPlan, projectSegment.getTaskSegment().isAggregating());
                        Callable<ProjectSegment> projectBuilder = this.createCallableForBuildingOneFullModule(buildContext, session, reactorBuildStatus, executionPlan, projectSegment, muxer, dependencyContext, concurrentBuildLogger, projectBuilds);
                        futures.add(service.submit(projectBuilder));
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e);
                    }
                }
                for (Future future : futures) {
                    future.get();
                }
                futures.clear();
            }
        }
        finally {
            projectBuilds.closeAll();
        }
        this.logger.info(concurrentBuildLogger.toString());
    }

    private Callable<ProjectSegment> createCallableForBuildingOneFullModule(final ReactorContext reactorContext, final MavenSession rootSession, final ReactorBuildStatus reactorBuildStatus, final MavenExecutionPlan executionPlan, final ProjectSegment projectBuild, ThreadOutputMuxer muxer, final DependencyContext dependencyContext, final ConcurrentBuildLogger concurrentBuildLogger, ProjectBuildList projectBuilds) {
        return new Callable<ProjectSegment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProjectSegment call() throws Exception {
                Iterator<ExecutionPlanItem> planItems = executionPlan.iterator();
                ExecutionPlanItem current = planItems.hasNext() ? planItems.next() : null;
                long buildStartTime = System.currentTimeMillis();
                if (reactorBuildStatus.isHaltedOrBlacklisted(projectBuild.getProject())) {
                    LifecycleWeaveBuilder.this.eventCatapult.fire(ExecutionEvent.Type.ProjectSkipped, projectBuild.getSession(), null);
                    return null;
                }
                LifecycleWeaveBuilder.this.eventCatapult.fire(ExecutionEvent.Type.ProjectStarted, projectBuild.getSession(), null);
                try {
                    while (current != null && !reactorBuildStatus.isHaltedOrBlacklisted(projectBuild.getProject())) {
                        ExecutionPlanItem nextPlanItem;
                        PhaseRecorder phaseRecorder = new PhaseRecorder(projectBuild.getProject());
                        BuildLogItem builtLogItem = concurrentBuildLogger.createBuildLogItem(projectBuild.getProject(), current);
                        Schedule schedule = current.getSchedule();
                        LifecycleWeaveBuilder.this.buildExecutionPlanItem(current, phaseRecorder, schedule, reactorContext, projectBuild, dependencyContext);
                        current.setComplete();
                        builtLogItem.setComplete();
                        ExecutionPlanItem executionPlanItem = nextPlanItem = planItems.hasNext() ? planItems.next() : null;
                        if (nextPlanItem != null) {
                            Schedule scheduleOfNext = nextPlanItem.getSchedule();
                            if (scheduleOfNext == null || !scheduleOfNext.isParallel()) {
                                LifecycleWeaveBuilder.this.waitForAppropriateUpstreamExecutionsToFinish(builtLogItem, nextPlanItem, projectBuild);
                            }
                            LifecycleWeaveBuilder.this.reResolveReactorDependencies(nextPlanItem, projectBuild);
                        }
                        current = nextPlanItem;
                    }
                    long wallClockTime = System.currentTimeMillis() - buildStartTime;
                    BuildSuccess summary = new BuildSuccess(projectBuild.getProject(), wallClockTime);
                    reactorContext.getResult().addBuildSummary(summary);
                    LifecycleWeaveBuilder.this.eventCatapult.fire(ExecutionEvent.Type.ProjectSucceeded, projectBuild.getSession(), null);
                }
                catch (Exception e) {
                    LifecycleWeaveBuilder.this.builderCommon.handleBuildError(reactorContext, rootSession, projectBuild.getProject(), e, buildStartTime);
                }
                finally {
                    if (current != null) {
                        executionPlan.forceAllComplete();
                    }
                }
                return null;
            }
        };
    }

    private void reResolveReactorDependencies(ExecutionPlanItem nextPlanItem, ProjectSegment projectBuild) {
        if (this.requiresReResolutionOfUpstreamReactorArtifacts(nextPlanItem)) {
            this.reresolveUpstreamProjectArtifacts(projectBuild);
        } else if (this.requiresReResolutionOfUpstreamTestScopedReactorArtifacts(nextPlanItem)) {
            this.reresolveUpstreamTestScopedArtifacts(projectBuild);
        }
    }

    private void waitForAppropriateUpstreamExecutionsToFinish(BuildLogItem builtLogItem, ExecutionPlanItem nextPlanItem, ProjectSegment projectBuild) throws InterruptedException {
        for (MavenProject upstreamProject : projectBuild.getImmediateUpstreamProjects()) {
            String nextPhase;
            MavenExecutionPlan upstreamPlan = this.executionPlans.get(upstreamProject);
            ExecutionPlanItem inSchedule = upstreamPlan.findLastInPhase(nextPhase = nextPlanItem.getLifecyclePhase());
            if (inSchedule != null) {
                long startWait = System.currentTimeMillis();
                inSchedule.waitUntilDone();
                builtLogItem.addWait(upstreamProject, inSchedule, startWait);
                continue;
            }
            if (!upstreamPlan.containsPhase(nextPhase)) {
                builtLogItem.addDependency(upstreamProject, "No phase tracking possible ");
                upstreamPlan.waitUntilAllDone();
                continue;
            }
            builtLogItem.addDependency(upstreamProject, "No schedule");
        }
    }

    private void reresolveUpstreamProjectArtifacts(ProjectSegment projectBuild) {
        for (MavenProject upstreamProject : projectBuild.getTransitiveUpstreamProjects()) {
            Artifact upStreamArtifact = upstreamProject.getArtifact();
            Artifact dependencyArtifact = LifecycleWeaveBuilder.findDependency(projectBuild.getProject(), upStreamArtifact);
            if (dependencyArtifact == null) continue;
            dependencyArtifact.setFile(upStreamArtifact.getFile());
            dependencyArtifact.setResolved(true);
            dependencyArtifact.setRepository(upStreamArtifact.getRepository());
        }
    }

    private void reresolveUpstreamTestScopedArtifacts(ProjectSegment projectBuild) {
        for (MavenProject upstreamProject : projectBuild.getTransitiveUpstreamProjects()) {
            Artifact upStreamArtifact = this.findTestScopedArtifact(upstreamProject);
            Artifact dependencyArtifact = LifecycleWeaveBuilder.findDependency(projectBuild.getProject(), upStreamArtifact);
            if (dependencyArtifact == null) continue;
            dependencyArtifact.setFile(upStreamArtifact.getFile());
            dependencyArtifact.setResolved(upStreamArtifact.isResolved());
            dependencyArtifact.setRepository(upStreamArtifact.getRepository());
        }
    }

    private Artifact findTestScopedArtifact(MavenProject upstreamProject) {
        if (upstreamProject == null) {
            return null;
        }
        List<Artifact> artifactList = upstreamProject.getAttachedArtifacts();
        for (Artifact artifact : artifactList) {
            if (!"test".equals(artifact.getScope())) continue;
            return artifact;
        }
        return null;
    }

    private static Artifact findDependency(MavenProject project, Artifact upStreamArtifact) {
        if (upStreamArtifact == null) {
            return null;
        }
        String key = ArtifactUtils.key((String)upStreamArtifact.getGroupId(), (String)upStreamArtifact.getArtifactId(), (String)upStreamArtifact.getVersion());
        Set<Artifact> deps = project.getDependencyArtifacts();
        for (Artifact dep : deps) {
            String depKey = ArtifactUtils.key((String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion());
            if (!key.equals(depKey)) continue;
            return dep;
        }
        return null;
    }

    private boolean requiresReResolutionOfUpstreamReactorArtifacts(ExecutionPlanItem nextExecutionPlanItem) {
        String phase = nextExecutionPlanItem.getLifecyclePhase();
        return "package".equals(phase) || "install".equals(phase) || "compile".equals(phase);
    }

    private boolean requiresReResolutionOfUpstreamTestScopedReactorArtifacts(ExecutionPlanItem nextExecutionPlanItem) {
        String phase = nextExecutionPlanItem.getLifecyclePhase();
        return "package".equals(phase) || "install".equals(phase) || "compile".equals(phase) || "test-compile".equals(phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExecutionPlanItem(ExecutionPlanItem current, PhaseRecorder phaseRecorder, Schedule schedule, ReactorContext reactorContext, ProjectSegment projectBuild, DependencyContext dependencyContext) throws LifecycleExecutionException {
        if (schedule != null && schedule.isMojoSynchronized()) {
            Plugin plugin = current.getPlugin();
            synchronized (plugin) {
                this.buildExecutionPlanItem(reactorContext, current, projectBuild, dependencyContext, phaseRecorder);
            }
        } else {
            this.buildExecutionPlanItem(reactorContext, current, projectBuild, dependencyContext, phaseRecorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExecutionPlanItem(ReactorContext reactorContext, ExecutionPlanItem node, ProjectSegment projectBuild, DependencyContext dependencyContext, PhaseRecorder phaseRecorder) throws LifecycleExecutionException {
        MavenProject currentProject = projectBuild.getProject();
        long buildStartTime = System.currentTimeMillis();
        MavenSession sessionForThisModule = projectBuild.getSession();
        try {
            if (reactorContext.getReactorBuildStatus().isHaltedOrBlacklisted(currentProject)) {
                return;
            }
            BuilderCommon.attachToThread(currentProject);
            this.mojoExecutor.execute(sessionForThisModule, node.getMojoExecution(), reactorContext.getProjectIndex(), dependencyContext, phaseRecorder);
            BuildSuccess summary = new BuildSuccess(currentProject, System.currentTimeMillis() - buildStartTime);
            reactorContext.getResult().addBuildSummary(summary);
        }
        finally {
            Thread.currentThread().setContextClassLoader(reactorContext.getOriginalContextClassLoader());
        }
    }

    public static boolean isWeaveMode(MavenExecutionRequest request) {
        return "true".equals(request.getUserProperties().getProperty("maven3.weaveMode"));
    }

    public static void setWeaveMode(Properties properties) {
        properties.setProperty("maven3.weaveMode", "true");
    }
}

