/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.lifecycle.internal.PhaseRecorder;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MojoExecutor.class)
public class MojoExecutor {
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private LifecycleDependencyResolver lifeCycleDependencyResolver;
    @Requirement
    private ExecutionEventCatapult eventCatapult;

    public void execute(MavenSession session, List<MojoExecution> mojoExecutions, ProjectIndex projectIndex, DependencyContext dependencyContext) throws LifecycleExecutionException {
        PhaseRecorder phaseRecorder = new PhaseRecorder(session.getCurrentProject());
        for (MojoExecution mojoExecution : mojoExecutions) {
            this.execute(session, mojoExecution, projectIndex, dependencyContext, phaseRecorder);
        }
    }

    public void execute(MavenSession session, MojoExecution mojoExecution, ProjectIndex projectIndex, DependencyContext dependencyContext, PhaseRecorder phaseRecorder) throws LifecycleExecutionException {
        this.execute(session, mojoExecution, projectIndex, dependencyContext);
        phaseRecorder.observeExecution(mojoExecution);
    }

    private void execute(MavenSession session, MojoExecution mojoExecution, ProjectIndex projectIndex, DependencyContext dependencyContext) throws LifecycleExecutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (mojoDescriptor.isProjectRequired() && !session.isUsingPOMsFromFilesystem()) {
            MissingProjectException cause = new MissingProjectException("Goal requires a project to execute but there is no POM in this directory (" + session.getExecutionRootDirectory() + ")." + " Please verify you invoked Maven from the correct directory.");
            throw new LifecycleExecutionException(mojoExecution, null, cause);
        }
        if (mojoDescriptor.isOnlineRequired() && session.isOffline()) {
            if (MojoExecution.Source.CLI.equals((Object)mojoExecution.getSource())) {
                IllegalStateException cause = new IllegalStateException("Goal requires online mode for execution but Maven is currently offline.");
                throw new LifecycleExecutionException(mojoExecution, session.getCurrentProject(), cause);
            }
            this.eventCatapult.fire(ExecutionEvent.Type.MojoSkipped, session, mojoExecution);
            return;
        }
        this.lifeCycleDependencyResolver.checkForUpdate(session, dependencyContext);
        List<MavenProject> forkedProjects = this.executeForkedExecutions(mojoExecution, session, projectIndex, dependencyContext);
        this.eventCatapult.fire(ExecutionEvent.Type.MojoStarted, session, mojoExecution);
        ArtifactFilter artifactFilter = this.getArtifactFilter(mojoDescriptor);
        List<MavenProject> resolvedProjects = LifecycleDependencyResolver.getProjects(session.getCurrentProject(), session, mojoDescriptor.isAggregator());
        for (MavenProject project : resolvedProjects) {
            project.setArtifactFilter(artifactFilter);
        }
        try {
            try {
                this.pluginManager.executeMojo(session, mojoExecution);
            }
            catch (MojoFailureException e) {
                throw new LifecycleExecutionException(mojoExecution, session.getCurrentProject(), e);
            }
            catch (MojoExecutionException e) {
                throw new LifecycleExecutionException(mojoExecution, session.getCurrentProject(), e);
            }
            catch (PluginConfigurationException e) {
                throw new LifecycleExecutionException(mojoExecution, session.getCurrentProject(), e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException(mojoExecution, session.getCurrentProject(), e);
            }
            this.eventCatapult.fire(ExecutionEvent.Type.MojoSucceeded, session, mojoExecution);
        }
        catch (LifecycleExecutionException e) {
            this.eventCatapult.fire(ExecutionEvent.Type.MojoFailed, session, mojoExecution);
            throw e;
        }
        finally {
            for (MavenProject forkedProject : forkedProjects) {
                forkedProject.setExecutionProject(null);
            }
        }
    }

    private ArtifactFilter getArtifactFilter(MojoDescriptor mojoDescriptor) {
        String scopeToResolve = mojoDescriptor.getDependencyResolutionRequired();
        String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
        ArrayList<String> scopes = new ArrayList<String>(2);
        if (StringUtils.isNotEmpty((String)scopeToCollect)) {
            scopes.add(scopeToCollect);
        }
        if (StringUtils.isNotEmpty((String)scopeToResolve)) {
            scopes.add(scopeToResolve);
        }
        if (scopes.isEmpty()) {
            return null;
        }
        return new CumulativeScopeArtifactFilter(scopes);
    }

    private List<MavenProject> executeForkedExecutions(MojoExecution mojoExecution, MavenSession session, ProjectIndex projectIndex, DependencyContext dependencyContext) throws LifecycleExecutionException {
        List<MavenProject> forkedProjects = Collections.emptyList();
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            this.eventCatapult.fire(ExecutionEvent.Type.ForkStarted, session, mojoExecution);
            MavenProject project = session.getCurrentProject();
            forkedProjects = new ArrayList<MavenProject>(forkedExecutions.size());
            dependencyContext = dependencyContext.clone();
            try {
                for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                    String projectId = fork.getKey();
                    int index = projectIndex.getIndices().get(projectId);
                    MavenProject forkedProject = projectIndex.getProjects().get(projectId);
                    forkedProjects.add(forkedProject);
                    MavenProject executedProject = forkedProject.clone();
                    forkedProject.setExecutionProject(executedProject);
                    List<MojoExecution> mojoExecutions = fork.getValue();
                    if (mojoExecutions.isEmpty()) continue;
                    try {
                        session.setCurrentProject(executedProject);
                        session.getProjects().set(index, executedProject);
                        projectIndex.getProjects().put(projectId, executedProject);
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectStarted, session, mojoExecution);
                        this.execute(session, mojoExecutions, projectIndex, dependencyContext);
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectSucceeded, session, mojoExecution);
                    }
                    catch (LifecycleExecutionException e) {
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectFailed, session, mojoExecution);
                        throw e;
                    }
                    finally {
                        projectIndex.getProjects().put(projectId, forkedProject);
                        session.getProjects().set(index, forkedProject);
                        session.setCurrentProject(project);
                    }
                }
                this.eventCatapult.fire(ExecutionEvent.Type.ForkSucceeded, session, mojoExecution);
            }
            catch (LifecycleExecutionException e) {
                this.eventCatapult.fire(ExecutionEvent.Type.ForkFailed, session, mojoExecution);
                throw e;
            }
        }
        return forkedProjects;
    }
}

