/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.ComponentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginDescriptorCache.class)
public class DefaultPluginDescriptorCache
implements PluginDescriptorCache {
    private Map<PluginDescriptorCache.Key, PluginDescriptor> descriptors = new HashMap<PluginDescriptorCache.Key, PluginDescriptor>(128);

    @Override
    public void flush() {
        this.descriptors.clear();
    }

    @Override
    public PluginDescriptorCache.Key createKey(Plugin plugin, RepositoryRequest repositoryRequest) {
        return new CacheKey(plugin, repositoryRequest);
    }

    @Override
    public void put(PluginDescriptorCache.Key cacheKey, PluginDescriptor pluginDescriptor) {
        this.descriptors.put(cacheKey, DefaultPluginDescriptorCache.clone(pluginDescriptor));
    }

    @Override
    public PluginDescriptor get(PluginDescriptorCache.Key cacheKey) {
        return DefaultPluginDescriptorCache.clone(this.descriptors.get(cacheKey));
    }

    private static PluginDescriptor clone(PluginDescriptor original) {
        PluginDescriptor clone = null;
        if (original != null) {
            clone = new PluginDescriptor();
            clone.setGroupId(original.getGroupId());
            clone.setArtifactId(original.getArtifactId());
            clone.setVersion(original.getVersion());
            clone.setGoalPrefix(original.getGoalPrefix());
            clone.setInheritedByDefault(original.isInheritedByDefault());
            clone.setName(original.getName());
            clone.setDescription(original.getDescription());
            clone.setPluginArtifact(ArtifactUtils.copyArtifactSafe((Artifact)original.getPluginArtifact()));
            clone.setComponents(DefaultPluginDescriptorCache.clone(original.getMojos(), clone));
            clone.setId(original.getId());
            clone.setIsolatedRealm(original.isIsolatedRealm());
            clone.setSource(original.getSource());
        }
        return clone;
    }

    private static List<ComponentDescriptor<?>> clone(List<MojoDescriptor> mojos, PluginDescriptor pluginDescriptor) {
        ArrayList<MojoDescriptor> clones = null;
        if (mojos != null) {
            clones = new ArrayList<MojoDescriptor>(mojos.size());
            for (MojoDescriptor mojo : mojos) {
                MojoDescriptor clone = mojo.clone();
                clone.setPluginDescriptor(pluginDescriptor);
                clones.add(clone);
            }
        }
        return clones;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheKey
    implements PluginDescriptorCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final List<ArtifactRepository> repositories;
        private final int hashCode;

        public CacheKey(Plugin plugin, RepositoryRequest repositoryRequest) {
            this.groupId = plugin.getGroupId();
            this.artifactId = plugin.getArtifactId();
            this.version = plugin.getVersion();
            this.repositories = new ArrayList<ArtifactRepository>(repositoryRequest.getRemoteRepositories().size() + 1);
            this.repositories.add(repositoryRequest.getLocalRepository());
            this.repositories.addAll(repositoryRequest.getRemoteRepositories());
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.version.hashCode();
            this.hashCode = hash = hash * 31 + CacheKey.repositoriesHashCode(this.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && CacheKey.repositoriesEquals(this.repositories, that.repositories);
        }

        public String toString() {
            return this.groupId + ':' + this.artifactId + ':' + this.version;
        }

        private static int repositoryHashCode(ArtifactRepository repository) {
            int result = 17;
            result = 31 * result + (repository.getId() != null ? repository.getId().hashCode() : 0);
            return result;
        }

        private static int repositoriesHashCode(List<ArtifactRepository> repositories) {
            int result = 17;
            for (ArtifactRepository repository : repositories) {
                result = 31 * result + CacheKey.repositoryHashCode(repository);
            }
            return result;
        }

        private static boolean repositoryEquals(ArtifactRepository r1, ArtifactRepository r2) {
            if (r1 == r2) {
                return true;
            }
            return CacheKey.eq(r1.getId(), r2.getId()) && CacheKey.eq(r1.getUrl(), r2.getUrl()) && CacheKey.repositoryPolicyEquals(r1.getReleases(), r2.getReleases()) && CacheKey.repositoryPolicyEquals(r1.getSnapshots(), r2.getSnapshots());
        }

        private static boolean repositoryPolicyEquals(ArtifactRepositoryPolicy p1, ArtifactRepositoryPolicy p2) {
            if (p1 == p2) {
                return true;
            }
            return p1.isEnabled() == p2.isEnabled() && CacheKey.eq(p1.getUpdatePolicy(), p2.getUpdatePolicy());
        }

        private static boolean repositoriesEquals(List<ArtifactRepository> r1, List<ArtifactRepository> r2) {
            if (r1.size() != r2.size()) {
                return false;
            }
            Iterator<ArtifactRepository> it1 = r1.iterator();
            Iterator<ArtifactRepository> it2 = r2.iterator();
            while (it1.hasNext()) {
                if (CacheKey.repositoryEquals(it1.next(), it2.next())) continue;
                return false;
            }
            return true;
        }

        private static <T> boolean eq(T s1, T s2) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
    }
}

