/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugin.version.internal.DefaultPluginVersionResult;
import org.apache.maven.repository.ArtifactDoesNotExistException;
import org.apache.maven.repository.ArtifactTransferFailedException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginVersionResolver.class)
public class DefaultPluginVersionResolver
implements PluginVersionResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;

    @Override
    public PluginVersionResult resolve(PluginVersionRequest request) throws PluginVersionResolutionException {
        this.logger.debug("Resolving plugin version for " + request.getGroupId() + ":" + request.getArtifactId());
        PluginVersionResult result = this.resolveFromProject(request);
        if (result == null) {
            result = this.resolveFromRepository(request);
            if (StringUtils.isEmpty((String)result.getVersion())) {
                throw new PluginVersionResolutionException(request.getGroupId(), request.getArtifactId(), request.getLocalRepository(), request.getRemoteRepositories(), "Plugin not found in any plugin repository");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from repository " + (result.getRepository() != null ? result.getRepository().getId() : "null"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin version for " + request.getGroupId() + ":" + request.getArtifactId() + " to " + result.getVersion() + " from POM " + request.getPom());
        }
        return result;
    }

    private PluginVersionResult resolveFromRepository(PluginVersionRequest request) throws PluginVersionResolutionException {
        DefaultPluginVersionResult result = new DefaultPluginVersionResult();
        Metadata mergedMetadata = new Metadata();
        ArtifactRepository localRepository = request.getLocalRepository();
        for (ArtifactRepository repository : request.getRemoteRepositories()) {
            String localPath = this.getLocalMetadataPath(request, repository);
            File artifactMetadataFile = new File(localRepository.getBasedir(), localPath);
            if (!request.isOffline() && !artifactMetadataFile.exists()) {
                String remotePath = this.getRemoteMetadataPath(request, repository);
                try {
                    this.repositorySystem.retrieve(repository, artifactMetadataFile, remotePath, request.getTransferListener());
                }
                catch (ArtifactTransferFailedException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("Failed to retrieve " + remotePath + " from " + repository.getId() + ": " + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    this.logger.warn("Failed to retrieve " + remotePath + " from " + repository.getId() + ": " + e.getMessage());
                    continue;
                }
                catch (ArtifactDoesNotExistException e) {
                    continue;
                }
            }
            if (!this.mergeMetadata(mergedMetadata, artifactMetadataFile)) continue;
            result.setRepository(repository);
        }
        String localPath = this.getLocalMetadataPath(request, localRepository);
        File artifactMetadataFile = new File(localRepository.getBasedir(), localPath);
        if (this.mergeMetadata(mergedMetadata, artifactMetadataFile)) {
            result.setRepository(localRepository);
        }
        if (mergedMetadata.getVersioning() != null) {
            String release = mergedMetadata.getVersioning().getRelease();
            if (StringUtils.isNotEmpty((String)release)) {
                result.setVersion(release);
            } else {
                String latest = mergedMetadata.getVersioning().getLatest();
                if (StringUtils.isNotEmpty((String)latest)) {
                    result.setVersion(latest);
                }
            }
        }
        if (StringUtils.isEmpty((String)result.getVersion())) {
            throw new PluginVersionResolutionException(request.getGroupId(), request.getArtifactId(), request.getLocalRepository(), request.getRemoteRepositories(), "Plugin not found in any plugin repository");
        }
        return result;
    }

    private String getLocalMetadataPath(PluginVersionRequest request, ArtifactRepository repository) {
        return request.getGroupId().replace('.', '/') + '/' + request.getArtifactId() + "/maven-metadata-" + repository.getId() + ".xml";
    }

    private String getRemoteMetadataPath(PluginVersionRequest request, ArtifactRepository repository) {
        return request.getGroupId().replace('.', '/') + '/' + request.getArtifactId() + "/maven-metadata.xml";
    }

    private boolean mergeMetadata(Metadata target, File metadataFile) {
        if (metadataFile.isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                Metadata repoMetadata = this.metadataReader.read(metadataFile, options);
                return this.mergeMetadata(target, repoMetadata);
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Failed to read metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
                }
                this.logger.warn("Failed to read metadata " + metadataFile + ": " + e.getMessage());
            }
        }
        return false;
    }

    private boolean mergeMetadata(Metadata target, Metadata source) {
        return target.merge(source);
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request) {
        Build build;
        PluginVersionResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginVersionResult resolveFromProject(PluginVersionRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!request.getGroupId().equals(plugin.getGroupId()) || !request.getArtifactId().equals(plugin.getArtifactId())) continue;
            if (plugin.getVersion() != null) {
                return new DefaultPluginVersionResult(plugin.getVersion());
            }
            return null;
        }
        return null;
    }
}

