/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Resource;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=MavenProjectHelper.class)
public class DefaultMavenProjectHelper
extends AbstractLogEnabled
implements MavenProjectHelper {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    public void attachArtifact(MavenProject project, String artifactType, String artifactClassifier, File artifactFile) {
        String type = artifactType;
        ArtifactHandler handler = null;
        if (type != null) {
            handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        }
        if (handler == null) {
            handler = this.artifactHandlerManager.getArtifactHandler("jar");
        }
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, artifactClassifier, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, (Artifact)artifact);
    }

    public void attachArtifact(MavenProject project, String artifactType, File artifactFile) {
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        AttachedArtifact artifact = new AttachedArtifact(project.getArtifact(), artifactType, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, (Artifact)artifact);
    }

    public void attachArtifact(MavenProject project, File artifactFile, String artifactClassifier) {
        Artifact projectArtifact = project.getArtifact();
        AttachedArtifact artifact = new AttachedArtifact(projectArtifact, projectArtifact.getType(), artifactClassifier, projectArtifact.getArtifactHandler());
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project, (Artifact)artifact);
    }

    public void attachArtifact(MavenProject project, Artifact artifact) {
        try {
            project.addAttachedArtifact(artifact);
        }
        catch (DuplicateArtifactAttachmentException dae) {
            this.getLogger().warn(dae.getMessage());
            throw dae;
        }
    }

    public void addResource(MavenProject project, String resourceDirectory, List includes, List excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addResource(resource);
    }

    public void addTestResource(MavenProject project, String resourceDirectory, List includes, List excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        project.addTestResource(resource);
    }

    private static class AttachedArtifact
    extends DefaultArtifact {
        private final Artifact parent;

        public AttachedArtifact(Artifact parent, String type, String classifier, ArtifactHandler artifactHandler) {
            super(parent.getGroupId(), parent.getArtifactId(), parent.getVersionRange(), parent.getScope(), type, classifier, artifactHandler, parent.isOptional());
            this.setDependencyTrail(Collections.singletonList(parent.getId()));
            this.parent = parent;
            if (this.getId().equals(parent.getId())) {
                throw new InvalidArtifactRTException(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), parent.getType(), "An attached artifact must have a different ID than its corresponding main artifact.");
            }
        }

        public AttachedArtifact(Artifact parent, String type, ArtifactHandler artifactHandler) {
            this(parent, type, null, artifactHandler);
        }

        public void setArtifactId(String artifactId) {
        }

        public List getAvailableVersions() {
            return this.parent.getAvailableVersions();
        }

        public void setAvailableVersions(List availableVersions) {
        }

        public String getBaseVersion() {
            return this.parent.getBaseVersion();
        }

        public void setBaseVersion(String baseVersion) {
        }

        public String getDownloadUrl() {
            return this.parent.getDownloadUrl();
        }

        public void setDownloadUrl(String downloadUrl) {
        }

        public void setGroupId(String groupId) {
        }

        public ArtifactRepository getRepository() {
            return this.parent.getRepository();
        }

        public void setRepository(ArtifactRepository repository) {
        }

        public String getScope() {
            return this.parent.getScope();
        }

        public void setScope(String scope) {
        }

        public String getVersion() {
            return this.parent.getVersion();
        }

        public void setVersion(String version) {
        }

        public VersionRange getVersionRange() {
            return this.parent.getVersionRange();
        }

        public void setVersionRange(VersionRange range) {
        }

        public boolean isRelease() {
            return this.parent.isRelease();
        }

        public void setRelease(boolean release) {
        }

        public boolean isSnapshot() {
            return this.parent.isSnapshot();
        }

        public void addMetadata(ArtifactMetadata metadata) {
        }

        public Collection getMetadataList() {
            return Collections.EMPTY_LIST;
        }
    }
}

