/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.AbstractModelBuildingListener;
import org.apache.maven.model.building.ModelBuildingEvent;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectRealmCache;

class DefaultModelBuildingListener
extends AbstractModelBuildingListener {
    private MavenProject project;
    private ProjectBuildingHelper projectBuildingHelper;
    private ProjectBuildingRequest projectBuildingRequest;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginRepositories;

    public DefaultModelBuildingListener(MavenProject project, ProjectBuildingHelper projectBuildingHelper, ProjectBuildingRequest projectBuildingRequest) {
        if (project == null) {
            throw new IllegalArgumentException("project missing");
        }
        this.project = project;
        if (projectBuildingHelper == null) {
            throw new IllegalArgumentException("project building helper missing");
        }
        this.projectBuildingHelper = projectBuildingHelper;
        if (projectBuildingRequest == null) {
            throw new IllegalArgumentException("project building request missing");
        }
        this.projectBuildingRequest = projectBuildingRequest;
        this.remoteRepositories = projectBuildingRequest.getRemoteRepositories();
        this.pluginRepositories = projectBuildingRequest.getPluginArtifactRepositories();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void buildExtensionsAssembled(ModelBuildingEvent event) {
        Model model = event.getModel();
        try {
            this.pluginRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getPluginRepositories(), this.pluginRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.getProblems().add(ModelProblem.Severity.ERROR, "Invalid plugin repository: " + e.getMessage(), e);
        }
        this.project.setPluginArtifactRepositories(this.pluginRepositories);
        if (event.getRequest().isProcessPlugins()) {
            try {
                ProjectRealmCache.CacheRecord record = this.projectBuildingHelper.createProjectRealm(this.project, model, this.projectBuildingRequest);
                this.project.setClassRealm(record.realm);
                this.project.setExtensionArtifactFilter(record.extensionArtifactFilter);
            }
            catch (PluginResolutionException e) {
                event.getProblems().add(ModelProblem.Severity.ERROR, "Unresolveable build extension: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (PluginVersionResolutionException e) {
                event.getProblems().add(ModelProblem.Severity.ERROR, "Unresolveable build extension: " + e.getMessage(), (Exception)e);
            }
            this.projectBuildingHelper.selectProjectRealm(this.project);
        }
        try {
            this.remoteRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getRepositories(), this.remoteRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.getProblems().add(ModelProblem.Severity.ERROR, "Invalid artifact repository: " + e.getMessage(), e);
        }
        this.project.setRemoteArtifactRepositories(this.remoteRepositories);
    }
}

