/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultProjectBuildingResult
implements ProjectBuildingResult {
    private String projectId;
    private File pomFile;
    private MavenProject project;
    private List<ModelProblem> problems;
    private ArtifactResolutionResult artifactResolutionResult;

    public DefaultProjectBuildingResult(MavenProject project, List<ModelProblem> problems, ArtifactResolutionResult dependencyResolutionResult) {
        this.projectId = project != null ? project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion() : "";
        this.pomFile = project != null ? project.getFile() : null;
        this.project = project;
        this.problems = problems;
        this.artifactResolutionResult = dependencyResolutionResult;
    }

    public DefaultProjectBuildingResult(String projectId, File pomFile, List<ModelProblem> problems) {
        this.projectId = projectId != null ? projectId : "";
        this.pomFile = pomFile;
        this.problems = problems;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<ModelProblem> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<ModelProblem>();
        }
        return this.problems;
    }

    @Override
    public ArtifactResolutionResult getArtifactResolutionResult() {
        return this.artifactResolutionResult;
    }
}

