/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.repository.RepositorySystem;

class RepositoryModelResolver
implements ModelResolver {
    private RepositorySystem repositorySystem;
    private ResolutionErrorHandler resolutionErrorHandler;
    private ProjectBuildingRequest projectBuildingRequest;
    private List<ArtifactRepository> pomRepositories;
    private List<ArtifactRepository> remoteRepositories;
    private ReactorModelPool reactorModelPool;
    private Set<String> repositoryIds;

    public RepositoryModelResolver(RepositorySystem repositorySystem, ResolutionErrorHandler resolutionErrorHandler, ProjectBuildingRequest projectBuildingRequest, ReactorModelPool reactorModelPool) {
        if (repositorySystem == null) {
            throw new IllegalArgumentException("no repository system specified");
        }
        this.repositorySystem = repositorySystem;
        if (resolutionErrorHandler == null) {
            throw new IllegalArgumentException("no resolution error handler specified");
        }
        this.resolutionErrorHandler = resolutionErrorHandler;
        if (projectBuildingRequest == null) {
            throw new IllegalArgumentException("no project building request specified");
        }
        this.projectBuildingRequest = projectBuildingRequest;
        this.remoteRepositories = new ArrayList<ArtifactRepository>();
        if (projectBuildingRequest.getRemoteRepositories() != null) {
            this.remoteRepositories.addAll(projectBuildingRequest.getRemoteRepositories());
        }
        this.pomRepositories = new ArrayList<ArtifactRepository>();
        this.repositoryIds = new HashSet<String>();
        this.reactorModelPool = reactorModelPool;
    }

    private RepositoryModelResolver(RepositoryModelResolver original) {
        this.repositorySystem = original.repositorySystem;
        this.resolutionErrorHandler = original.resolutionErrorHandler;
        this.projectBuildingRequest = original.projectBuildingRequest;
        this.reactorModelPool = original.reactorModelPool;
        this.remoteRepositories = new ArrayList<ArtifactRepository>(original.remoteRepositories);
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
        this.pomRepositories = new ArrayList<ArtifactRepository>(original.pomRepositories);
    }

    public ModelResolver newCopy() {
        return new RepositoryModelResolver(this);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        try {
            ArtifactRepository repo = this.repositorySystem.buildArtifactRepository(repository);
            this.repositorySystem.injectMirror(Arrays.asList(repo), this.projectBuildingRequest.getMirrors());
            this.repositorySystem.injectProxy(Arrays.asList(repo), this.projectBuildingRequest.getProxies());
            this.repositorySystem.injectAuthentication(Arrays.asList(repo), this.projectBuildingRequest.getServers());
            this.pomRepositories.add(repo);
            this.remoteRepositories = new ArrayList<ArtifactRepository>();
            this.remoteRepositories.addAll(this.pomRepositories);
            this.remoteRepositories.addAll(this.projectBuildingRequest.getRemoteRepositories());
            this.remoteRepositories = this.repositorySystem.getEffectiveRepositories(this.remoteRepositories);
        }
        catch (Exception e) {
            throw new InvalidRepositoryException(e.getMessage(), repository, (Throwable)e);
        }
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pomFile = null;
        if (this.reactorModelPool != null) {
            pomFile = this.reactorModelPool.get(groupId, artifactId, version);
        }
        if (pomFile == null) {
            Artifact artifactParent = this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
            ArtifactResolutionRequest request = new ArtifactResolutionRequest();
            request.setArtifact(artifactParent);
            request.setRemoteRepositories((List)this.remoteRepositories);
            request.setLocalRepository(this.projectBuildingRequest.getLocalRepository());
            request.setOffline(this.projectBuildingRequest.isOffline());
            request.setCache(this.projectBuildingRequest.getRepositoryCache());
            request.setTransferListener(this.projectBuildingRequest.getTransferListener());
            request.setForceUpdate(this.projectBuildingRequest.isForceUpdate());
            ArtifactResolutionResult result = this.repositorySystem.resolve(request);
            try {
                this.resolutionErrorHandler.throwErrors(request, result);
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException("Failed to resolve POM for " + groupId + ":" + artifactId + ":" + version + " due to " + e.getMessage(), groupId, artifactId, version, (Throwable)e);
            }
            pomFile = artifactParent.getFile();
        }
        return new FileModelSource(pomFile);
    }
}

