/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ArtifactWithDependencies;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import org.apache.maven.repository.legacy.metadata.MetadataResolutionRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactMetadataSource.class, hint="maven")
public class MavenMetadataSource
implements ArtifactMetadataSource {
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;
    @Requirement
    private ArtifactFactory repositorySystem;
    private ProjectBuilder projectBuilder;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private Logger logger;
    @Requirement
    private MavenMetadataCache cache;
    @Requirement
    private LegacySupport legacySupport;

    private void injectSession(MetadataResolutionRequest request) {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setServers(session.getRequest().getServers());
            request.setMirrors(session.getRequest().getMirrors());
            request.setProxies(session.getRequest().getProxies());
            request.setTransferListener(session.getRequest().getTransferListener());
        }
    }

    @Override
    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        return this.retrieve(artifact, localRepository, remoteRepositories, false);
    }

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, boolean resolveManagedVersions) throws ArtifactMetadataRetrievalException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        this.injectSession(request);
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        request.setResolveManagedVersions(resolveManagedVersions);
        return this.retrieve(request);
    }

    @Override
    public ResolutionGroup retrieve(MetadataResolutionRequest request) throws ArtifactMetadataRetrievalException {
        List<Object> dependencies;
        Artifact pomArtifact;
        Artifact artifact = request.getArtifact();
        if (artifact.getScope() != null && artifact.getScope().equals("system")) {
            return new ResolutionGroup(null, null, null);
        }
        ResolutionGroup cached = this.cache.get(artifact, request.isResolveManagedVersions(), request.getLocalRepository(), request.getRemoteRepositories());
        if (cached != null && (!request.isForceUpdate() || this.hasFile(cached.getPomArtifact()))) {
            return cached;
        }
        List managedDependencies = null;
        List<ArtifactRepository> pomRepositories = null;
        Artifact relocatedArtifact = null;
        if (artifact instanceof ArtifactWithDependencies) {
            pomArtifact = artifact;
            dependencies = ((ArtifactWithDependencies)artifact).getDependencies();
            managedDependencies = ((ArtifactWithDependencies)artifact).getManagedDependencies();
        } else {
            ProjectRelocation rel = this.retrieveRelocatedProject(artifact, request);
            if (rel == null) {
                return null;
            }
            pomArtifact = rel.pomArtifact;
            relocatedArtifact = rel.relocatedArtifact;
            if (rel.project == null) {
                dependencies = Collections.emptyList();
            } else {
                dependencies = rel.project.getDependencies();
                DependencyManagement depMngt = rel.project.getDependencyManagement();
                managedDependencies = depMngt != null ? depMngt.getDependencies() : null;
                pomRepositories = rel.project.getRemoteArtifactRepositories();
            }
        }
        Set<Artifact> artifacts = Collections.emptySet();
        if (!artifact.getArtifactHandler().isIncludesDependencies()) {
            artifacts = new LinkedHashSet();
            for (Dependency dependency : dependencies) {
                Artifact dependencyArtifact = this.createDependencyArtifact(dependency, artifact, pomArtifact);
                if (dependencyArtifact == null) continue;
                artifacts.add(dependencyArtifact);
            }
        }
        HashMap<String, Artifact> managedVersions = null;
        if (managedDependencies != null && request.isResolveManagedVersions()) {
            managedVersions = new HashMap<String, Artifact>();
            for (Dependency managedDependency : managedDependencies) {
                Artifact managedArtifact = this.createDependencyArtifact(managedDependency, null, pomArtifact);
                managedVersions.put(managedDependency.getManagementKey(), managedArtifact);
            }
        }
        List<ArtifactRepository> list = this.aggregateRepositories(request.getRemoteRepositories(), pomRepositories);
        ResolutionGroup result = new ResolutionGroup(pomArtifact, relocatedArtifact, artifacts, managedVersions, list);
        this.cache.put(artifact, request.isResolveManagedVersions(), request.getLocalRepository(), request.getRemoteRepositories(), result);
        return result;
    }

    private boolean hasFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && artifact.getFile().exists();
    }

    private List<ArtifactRepository> aggregateRepositories(List<ArtifactRepository> requestRepositories, List<ArtifactRepository> pomRepositories) {
        List<ArtifactRepository> repositories = requestRepositories;
        if (pomRepositories != null && !pomRepositories.isEmpty()) {
            LinkedHashMap<String, ArtifactRepository> repos = new LinkedHashMap<String, ArtifactRepository>();
            for (ArtifactRepository repo : requestRepositories) {
                if (repos.containsKey(repo.getId())) continue;
                repos.put(repo.getId(), repo);
            }
            for (ArtifactRepository repo : pomRepositories) {
                if (repos.containsKey(repo.getId())) continue;
                repos.put(repo.getId(), repo);
            }
            repositories = new ArrayList(repos.values());
        }
        return repositories;
    }

    private Artifact createDependencyArtifact(Dependency dependency, Artifact owner, Artifact pom) throws ArtifactMetadataRetrievalException {
        try {
            String inheritedScope = owner != null ? owner.getScope() : null;
            ArtifactFilter inheritedFilter = owner != null ? owner.getDependencyFilter() : null;
            return MavenMetadataSource.createDependencyArtifact(this.repositorySystem, dependency, inheritedScope, inheritedFilter);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ArtifactMetadataRetrievalException("Invalid version for dependency " + dependency.getManagementKey() + ": " + e.getMessage(), e, pom);
        }
    }

    private static Artifact createDependencyArtifact(ArtifactFactory factory, Dependency dependency, String inheritedScope, ArtifactFilter inheritedFilter) throws InvalidVersionSpecificationException {
        String effectiveScope = MavenMetadataSource.getEffectiveScope(dependency.getScope(), inheritedScope);
        if (effectiveScope == null) {
            return null;
        }
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
        Artifact dependencyArtifact = factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), effectiveScope, dependency.isOptional());
        ArtifactFilter dependencyFilter = inheritedFilter;
        if (dependencyFilter != null && !dependencyFilter.include(dependencyArtifact)) {
            return null;
        }
        if ("system".equals(effectiveScope)) {
            dependencyArtifact.setFile(new File(dependency.getSystemPath()));
        }
        dependencyArtifact.setDependencyFilter(MavenMetadataSource.createDependencyFilter(dependency, dependencyFilter));
        return dependencyArtifact;
    }

    private static String getEffectiveScope(String originalScope, String inheritedScope) {
        String effectiveScope = "runtime";
        if (originalScope == null) {
            originalScope = "compile";
        }
        if (inheritedScope == null) {
            effectiveScope = originalScope;
        } else if ("test".equals(originalScope) || "provided".equals(originalScope)) {
            effectiveScope = null;
        } else if ("system".equals(originalScope)) {
            effectiveScope = "system";
        } else if ("compile".equals(originalScope) && "compile".equals(inheritedScope)) {
            effectiveScope = "compile";
        } else if ("test".equals(inheritedScope)) {
            effectiveScope = "test";
        } else if ("provided".equals(inheritedScope)) {
            effectiveScope = "provided";
        }
        return effectiveScope;
    }

    private static ArtifactFilter createDependencyFilter(Dependency dependency, ArtifactFilter inheritedFilter) {
        ArtifactFilter effectiveFilter = inheritedFilter;
        if (!dependency.getExclusions().isEmpty()) {
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion e : dependency.getExclusions()) {
                exclusions.add(e.getGroupId() + ':' + e.getArtifactId());
            }
            effectiveFilter = new ExcludesArtifactFilter(exclusions);
            if (inheritedFilter != null) {
                effectiveFilter = new AndArtifactFilter(Arrays.asList(inheritedFilter, effectiveFilter));
            }
        }
        return effectiveFilter;
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        this.injectSession(request);
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        return this.retrieveAvailableVersions(request);
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(MetadataResolutionRequest request) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(request.getArtifact());
        try {
            this.repositoryMetadataManager.resolve(metadata, request);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e, request.getArtifact());
        }
        List availableVersions = request.getLocalRepository().findVersions(request.getArtifact());
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata(), availableVersions);
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersionsFromDeploymentRepository(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolveAlways(metadata, localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e, artifact);
        }
        List availableVersions = localRepository.findVersions(artifact);
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata(), availableVersions);
    }

    private List<ArtifactVersion> retrieveAvailableVersionsFromMetadata(Metadata repoMetadata, List<String> availableVersions) {
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            versions.addAll(repoMetadata.getVersioning().getVersions());
        }
        versions.addAll(availableVersions);
        ArrayList<ArtifactVersion> artifactVersions = new ArrayList<ArtifactVersion>(versions.size());
        for (String version : versions) {
            artifactVersions.add((ArtifactVersion)new DefaultArtifactVersion(version));
        }
        return artifactVersions;
    }

    @Deprecated
    public static Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, List<Dependency> dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (Dependency d : dependencies) {
            Artifact dependencyArtifact;
            try {
                dependencyArtifact = MavenMetadataSource.createDependencyArtifact(artifactFactory, d, inheritedScope, dependencyFilter);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException(project.getId(), d, project.getFile(), e);
            }
            if (dependencyArtifact == null) continue;
            artifacts.add(dependencyArtifact);
        }
        return artifacts;
    }

    private ProjectBuilder getProjectBuilder() {
        if (this.projectBuilder != null) {
            return this.projectBuilder;
        }
        try {
            this.projectBuilder = (ProjectBuilder)this.container.lookup(ProjectBuilder.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return this.projectBuilder;
    }

    private ProjectRelocation retrieveRelocatedProject(Artifact artifact, MetadataResolutionRequest repositoryRequest) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact;
        MavenProject project;
        Artifact relocatedArtifact = artifact;
        boolean done = false;
        do {
            project = null;
            pomArtifact = this.repositorySystem.createProjectArtifact(relocatedArtifact.getGroupId(), relocatedArtifact.getArtifactId(), relocatedArtifact.getVersion(), relocatedArtifact.getScope());
            if ("pom".equals(relocatedArtifact.getType())) {
                pomArtifact.setFile(relocatedArtifact.getFile());
            }
            if ("system".equals(relocatedArtifact.getScope())) {
                done = true;
                continue;
            }
            try {
                DefaultProjectBuildingRequest configuration = new DefaultProjectBuildingRequest();
                configuration.setRepositoryCache(repositoryRequest.getCache());
                configuration.setLocalRepository(repositoryRequest.getLocalRepository());
                configuration.setRemoteRepositories(repositoryRequest.getRemoteRepositories());
                configuration.setOffline(repositoryRequest.isOffline());
                configuration.setForceUpdate(repositoryRequest.isForceUpdate());
                configuration.setValidationLevel(0);
                configuration.setProcessPlugins(false);
                configuration.setSystemProperties(this.getSystemProperties());
                configuration.setTransferListener(repositoryRequest.getTransferListener());
                configuration.setServers(repositoryRequest.getServers());
                configuration.setMirrors(repositoryRequest.getMirrors());
                configuration.setProxies(repositoryRequest.getProxies());
                project = this.getProjectBuilder().build(pomArtifact, (ProjectBuildingRequest)configuration).getProject();
            }
            catch (ProjectBuildingException e) {
                String message;
                ModelProblem missingParentPom = this.hasMissingParentPom(e);
                if (missingParentPom != null) {
                    throw new ArtifactMetadataRetrievalException("Failed to process POM for " + relocatedArtifact.getId() + ": " + missingParentPom.getMessage(), missingParentPom.getException(), relocatedArtifact);
                }
                if (e.getCause() instanceof MultipleArtifactsNotFoundException) {
                    message = "Missing POM for " + relocatedArtifact.getId();
                } else {
                    if (e.getCause() instanceof ArtifactResolutionException) {
                        throw new ArtifactMetadataRetrievalException("Failed to retrieve POM for " + relocatedArtifact.getId() + ": " + e.getCause().getMessage(), e.getCause(), relocatedArtifact);
                    }
                    message = "Invalid POM for " + relocatedArtifact.getId() + ", transitive dependencies (if any) will not be available" + ", enable debug logging for more details";
                }
                if (this.logger.isDebugEnabled()) {
                    message = message + ": " + e.getMessage();
                }
                this.logger.warn(message);
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    relocatedArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocatedArtifact == artifact) {
                        relocatedArtifact = ArtifactUtils.copyArtifact((Artifact)artifact);
                    }
                    if (relocation.getGroupId() != null) {
                        relocatedArtifact.setGroupId(relocation.getGroupId());
                        project.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        relocatedArtifact.setArtifactId(relocation.getArtifactId());
                        project.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        relocatedArtifact.setVersionRange(VersionRange.createFromVersion((String)relocation.getVersion()));
                        project.setVersion(relocation.getVersion());
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(relocatedArtifact)) {
                        return null;
                    }
                    List<ArtifactVersion> available = artifact.getAvailableVersions();
                    if (available != null && !available.isEmpty()) {
                        DefaultMetadataResolutionRequest metadataRequest = new DefaultMetadataResolutionRequest(repositoryRequest);
                        metadataRequest.setArtifact(relocatedArtifact);
                        available = this.retrieveAvailableVersions(metadataRequest);
                        relocatedArtifact.setAvailableVersions(available);
                    }
                    String message = "\n  This artifact has been relocated to " + relocatedArtifact.getGroupId() + ":" + relocatedArtifact.getArtifactId() + ":" + relocatedArtifact.getVersion() + ".\n";
                    if (relocation.getMessage() != null) {
                        message = message + "  " + relocation.getMessage() + "\n";
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.logger.warn("While downloading " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion() + message + "\n");
                        continue;
                    }
                    this.logger.debug("While downloading " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion() + message + "\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        ProjectRelocation rel = new ProjectRelocation();
        rel.project = project;
        rel.pomArtifact = pomArtifact;
        rel.relocatedArtifact = relocatedArtifact == artifact ? null : relocatedArtifact;
        return rel;
    }

    private ModelProblem hasMissingParentPom(ProjectBuildingException e) {
        if (e.getCause() instanceof ModelBuildingException) {
            ModelBuildingException mbe = (ModelBuildingException)e.getCause();
            for (ModelProblem problem : mbe.getProblems()) {
                if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                return problem;
            }
        }
        return null;
    }

    private Properties getSystemProperties() {
        Properties props = new Properties();
        EnvironmentUtils.addEnvVars(props);
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    private static final class ProjectRelocation {
        private MavenProject project;
        private Artifact pomArtifact;
        private Artifact relocatedArtifact;

        private ProjectRelocation() {
        }
    }
}

