/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.validation;

import java.util.List;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsProblemCollector;
import org.apache.maven.settings.validation.SettingsValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SettingsValidator.class)
public class DefaultSettingsValidator
implements SettingsValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    @Override
    public void validate(Settings settings, SettingsProblemCollector problems) {
        List profiles;
        List mirrors;
        List servers;
        List pluginGroups;
        if (settings.isUsePluginRegistry()) {
            this.addWarn(problems, "'usePluginRegistry' is deprecated and has no effect.");
        }
        if ((pluginGroups = settings.getPluginGroups()) != null) {
            for (int i = 0; i < pluginGroups.size(); ++i) {
                String pluginGroup = ((String)pluginGroups.get(i)).trim();
                if (StringUtils.isBlank((String)pluginGroup)) {
                    this.addError(problems, "'pluginGroups.pluginGroup[" + i + "]' must not be empty.");
                    continue;
                }
                if (pluginGroup.matches(ID_REGEX)) continue;
                this.addError(problems, "'pluginGroups.pluginGroup[" + i + "]' must denote a valid group id and match the pattern " + ID_REGEX);
            }
        }
        if ((servers = settings.getServers()) != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Server server = (Server)servers.get(i);
                this.validateStringNotEmpty(problems, "servers.server[" + i + "].id", server.getId(), null);
            }
        }
        if ((mirrors = settings.getMirrors()) != null) {
            for (Mirror mirror : mirrors) {
                this.validateStringNotEmpty(problems, "mirrors.mirror.id", mirror.getId(), mirror.getUrl());
                if ("local".equals(mirror.getId())) {
                    this.addError(problems, "'mirrors.mirror.id' must not be 'local', this identifier is reserved.");
                }
                this.validateStringNotEmpty(problems, "mirrors.mirror.url", mirror.getUrl(), mirror.getId());
                this.validateStringNotEmpty(problems, "mirrors.mirror.mirrorOf", mirror.getMirrorOf(), mirror.getId());
            }
        }
        if ((profiles = settings.getProfiles()) != null) {
            for (Profile profile : profiles) {
                this.validateRepositories(problems, profile.getRepositories(), "repositories.repository");
                this.validateRepositories(problems, profile.getPluginRepositories(), "pluginRepositories.pluginRepository");
            }
        }
    }

    private void validateRepositories(SettingsProblemCollector problems, List<Repository> repositories, String prefix) {
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(problems, prefix + ".id", repository.getId(), repository.getUrl());
            if ("local".equals(repository.getId())) {
                this.addError(problems, "'" + prefix + ".id' must not be 'local', this identifier is reserved.");
            }
            this.validateStringNotEmpty(problems, prefix + ".url", repository.getUrl(), repository.getId());
            if (!"legacy".equals(repository.getLayout())) continue;
            this.addWarn(problems, "'" + prefix + ".layout' for " + repository.getId() + " uses the deprecated value 'legacy'.");
        }
    }

    private boolean validateStringNotEmpty(SettingsProblemCollector problems, String fieldName, String string, String sourceHint) {
        if (!this.validateNotNull(problems, fieldName, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        String msg = sourceHint != null ? "'" + fieldName + "' is missing for " + sourceHint : "'" + fieldName + "' is missing.";
        this.addError(problems, msg);
        return false;
    }

    private boolean validateNotNull(SettingsProblemCollector problems, String fieldName, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        String msg = sourceHint != null ? "'" + fieldName + "' is missing for " + sourceHint : "'" + fieldName + "' is missing.";
        this.addError(problems, msg);
        return false;
    }

    private void addError(SettingsProblemCollector problems, String msg) {
        problems.add(SettingsProblem.Severity.ERROR, msg, -1, -1, null);
    }

    private void addWarn(SettingsProblemCollector problems, String msg) {
        problems.add(SettingsProblem.Severity.WARNING, msg, -1, -1, null);
    }
}

