/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.system.server.profileservice.profile.plugins;

import java.util.Collections;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.profile.metadata.CommonProfileNameSpaces;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileMetaData;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitor;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.profileservice.spi.repository.ArtifactId;
import org.jboss.profileservice.spi.virtual.VirtualArtifactMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * TODO does this make sense ?
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
@JBossXmlSchema(namespace=CommonProfileNameSpaces.CLASSPATH_PROFILE_NAMESPACE,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true,
      replacePropertyRefs=true)
@XmlRootElement(name = "classpath")
@XmlType(name = "classpathProfileType", propOrder = "deployments")
public class ClassPathProfileMetaData extends AbstractProfileMetaData implements DomainMetaDataFragment
{

   /** The system classpath items. */
   private List<ClassPathItem> classPathItems; 
   
   @Override
   @XmlAttribute(name = "name")
   public String getName()
   {
      return super.getName();
   }
   
   @Override
   public String getNameSpace()
   {
      return CommonProfileNameSpaces.CLASSPATH_PROFILE_NAMESPACE;
   }

   @Override
   public void visit(DomainMetaDataFragmentVisitor visitor)
   {
      visitor.addProfileMetaData(this);
   }

   @Override
   @XmlElement(name = "source", type = ClassPathItem.class)
   public List<ClassPathItem> getDeployments()
   {
      return classPathItems;
   }
   
   public void setDeployments(List<ClassPathItem> classPathItems)
   {
      this.classPathItems = classPathItems;
   }

   @Override
   @XmlTransient
   public ProfileSourceMetaData getSource()
   {
      return null;
   }

   public static class ClassPathItem implements ProfileDeploymentMetaData
   {
      private String path;
      private String archives;
      
      @XmlAttribute(name = "path")
      public String getPath()
      {
         return path;
      }
      public void setPath(String path)
      {
         this.path = path;
      }
      
      @XmlAttribute(name = "archives")
      public String getArchives()
      {
         return archives;
      }
      public void setArchives(String archives)
      {
         this.archives = archives;
      }
      
      @Override
      @XmlTransient
      public String getName()
      {
         // TODO
         return getPath();
      }
      
      @Override
      @XmlTransient
      public ArtifactId getArtifact()
      {
         return new FileArtifactId(getPath());
      }
      
      @Override
      @XmlTransient
      public List<VirtualArtifactMetaData> getArtifacts()
      {
         return Collections.emptyList();
      }
      
      @Override
      @XmlTransient
      public List<VirtualDeploymentMetaData> getChildren()
      {
         return Collections.emptyList();
      }
      
      @Override
      public void visit(ProfileMetaDataVisitor visitor)
      {
         // nothing
      }
   }
   
}

