/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.weld.integration.deployer.env;

import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/**
 * EjbServices Deployer.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class EjbServicesDeployer extends AbstractBootstrapInfoDeployer
{
   /** The ejb services class name */
   private String ejbServicesClassName = "org.jboss.weld.integration.ejb.JBossEjbServices";

   /** The ejb injection services class name */
   private String ejbInjectionServicesClassName = "org.jboss.weld.integration.ejb.JBossEjbInjectionServices";

   public EjbServicesDeployer()
   {
      super(true);
      addOutput(BootstrapInfo.EJB_SERVICES);
   }

   public void deployInternal(DeploymentUnit unit, BootstrapInfo info) throws DeploymentException
   {
      ValueMetaData ejbServicesValue = createServiceConnector("JBossEjbServices", ejbServicesClassName, unit);
      info.setEjbServices(ejbServicesValue);

      ValueMetaData ejbInjectionServicesValue = createServiceConnector("JBossEjbInjectionServices", ejbInjectionServicesClassName, unit);
      info.setEjbInjectionServices(ejbInjectionServicesValue);
   }

   /**
    * Set ejb services class name.
    *
    * @param ejbServicesClassName the ejb services classname
    */
   public void setEjbServicesClassName(String ejbServicesClassName)
   {
      this.ejbServicesClassName = ejbServicesClassName;
   }

   /**
    * Set ejb injection services class name.
    *
    * @param ejbInjectionServicesClassName the ejb injection services classname
    */
   public void setEjbInjectionServicesClassName(String ejbInjectionServicesClassName)
   {
      this.ejbInjectionServicesClassName = ejbInjectionServicesClassName;
   }
}