/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.cluster.ejb3.stateful;

import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 108925 $
 */
@Stateless()
@TransactionManagement(TransactionManagementType.BEAN)
@Remote(Tester.class)
public class TesterBean implements Tester
{
   @Resource private UserTransaction ut;

   public void testSessionSynchronization() throws Exception
   {
      StatefulSyncLocal sfsb = (StatefulSyncLocal)new InitialContext().lookup("StatefulSyncBean/local");
      sfsb.setState("hello");
      sfsb.setBeforeCalled(false);

      ut.begin();
      sfsb.setState("world");
      ut.rollback();

      if (!sfsb.getState().equals("hello")) throw new RuntimeException("rollback didn't work");
      if (!sfsb.isBeforeCalled()) throw new RuntimeException("BEFORE WAS NOT CALLED");

      // test new proxy

      sfsb = (StatefulSyncLocal)new InitialContext().lookup("StatefulSyncBean/local");
      if (sfsb.getState() != null) throw new RuntimeException("State should be null: " + sfsb.getState());
   }

   public void testRollback1() throws Exception
   {
      RemoveTest test = (RemoveTest)new InitialContext().lookup("RemoveTestBean/local");
      ut.begin();
      test.callRollbackOnly();
      ut.rollback();
   }
   public void testRollback2() throws Exception
   {
      RemoveTest test = (RemoveTest)new InitialContext().lookup("RemoveTestBean/local");
      ut.begin();
      ut.setRollbackOnly();
      test.removeit();
      ut.rollback();
   }
}
