/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.jboss.wsf.common.integration.JMSDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.config.CXFInitializer;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;

public class JMSEndpointDeploymentAspectDelegate
extends JMSDeploymentAspect {
    public void start(Deployment dep) {
        CXFInitializer.waitForDefaultBusAvailability();
        if (dep.getAttachment(JMSEndpointsMetaData.class) != null) {
            JMSEndpointsMetaData jmsEndpoints = (JMSEndpointsMetaData)dep.getAttachment(JMSEndpointsMetaData.class);
            URL url = jmsEndpoints.getDescriptorURL();
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(dep.getRuntimeClassLoader());
                Bus bus = new JBossWSSpringBusFactory().createBus(url);
                dep.addAttachment(Bus.class, (Object)bus);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to deploy jms endpoints deployment " + url));
                throw new RuntimeException(e);
            }
            finally {
                BusFactory.setThreadDefaultBus(null);
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    public void stop(Deployment dep) {
        this.log.debugf("Undeploying jms endpoints in %s", new Object[]{dep.getSimpleName()});
        if (dep.getAttachment(Bus.class) != null) {
            Bus bus = (Bus)dep.getAttachment(Bus.class);
            bus.shutdown(false);
        }
    }
}

