/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.hasessionstate.server;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.hasessionstate.server.HASessionStateImpl;
import org.jboss.ha.hasessionstate.server.HASessionStateServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class HASessionStateService
extends ServiceMBeanSupport
implements HASessionStateServiceMBean {
    protected String jndiName;
    protected HAPartition clusterPartition;
    protected long beanCleaningDelay = 0L;
    protected HASessionStateImpl sessionState;

    public String getName() {
        return this.getJndiName();
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String newName) {
        this.jndiName = newName;
    }

    public String getPartitionName() {
        return this.clusterPartition.getPartitionName();
    }

    public HAPartition getHAPartition() {
        return this.clusterPartition;
    }

    public void setHAPartition(HAPartition clusterPartition) {
        this.clusterPartition = clusterPartition;
    }

    public long getBeanCleaningDelay() {
        if (this.sessionState == null) {
            return this.beanCleaningDelay;
        }
        return this.sessionState.beanCleaningDelay;
    }

    public void setBeanCleaningDelay(long newDelay) {
        this.beanCleaningDelay = newDelay;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        if (this.clusterPartition == null) {
            throw new IllegalStateException("HAPartition property must be set before starting SessionState service");
        }
        this.sessionState = new HASessionStateImpl(this.jndiName, this.clusterPartition, this.beanCleaningDelay);
        this.sessionState.init();
    }

    protected void startService() throws Exception {
        this.sessionState.start();
    }

    protected void stopService() throws Exception {
        this.sessionState.stop();
    }

    protected void destroyService() throws Exception {
        this.sessionState.destroy();
        this.sessionState = null;
    }
}

