/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;

public class ReflectedDispatcher
extends AbstractInterceptor {
    protected Method method = null;
    protected boolean dynamic;

    public ReflectedDispatcher() {
        super("Reflected Dispatcher");
    }

    public ReflectedDispatcher(boolean dynamic) {
        this();
        this.dynamic = dynamic;
    }

    public ReflectedDispatcher(Method m, boolean dynamic) {
        this(dynamic);
        this.method = m;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Method invokeMethod = this.method;
        Object target = invocation.getTarget();
        String operationName = invocation.getName();
        if (this.dynamic) {
            Object descriptorTarget;
            Descriptor descriptor;
            String opName = operationName;
            String opClass = null;
            int dot = opName.lastIndexOf(46);
            if (dot != -1) {
                opClass = operationName.substring(0, dot);
                opName = operationName.substring(dot + 1);
            }
            if ((descriptor = invocation.getDescriptor()) != null && (descriptorTarget = descriptor.getFieldValue("targetObject")) != null) {
                Class<?>[] sig;
                String targetType = (String)descriptor.getFieldValue("targetType");
                if (!"ObjectReference".equalsIgnoreCase(targetType)) {
                    throw new InvalidTargetObjectTypeException("Target type is " + targetType);
                }
                target = descriptorTarget;
                Class<?> clazz = null;
                String className = (String)descriptor.getFieldValue("class");
                if (className == null) {
                    className = opClass;
                }
                if (className == null) {
                    clazz = target.getClass();
                } else {
                    try {
                        if (clazz == null) {
                            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                        }
                    }
                    catch (Exception e) {
                        throw new ReflectionException(e, "Error loading class for operation " + opName);
                    }
                }
                try {
                    sig = invocation.getSignatureClasses();
                }
                catch (Exception e) {
                    throw new ReflectionException(e, "Error loading signature classes for operation " + opName);
                }
                try {
                    invokeMethod = clazz.getDeclaredMethod(opName, sig);
                }
                catch (Exception e) {
                    throw new ReflectionException(e, "Error getting method for operation " + opName);
                }
            }
        }
        if (target == null) {
            String msg = "Failed to find method for operation: " + invocation + " on resource: " + invocation.getInvoker().getResource() + " objectName: " + invocation.getInvoker().getObjectName();
            throw new ReflectionException(new NullPointerException(msg));
        }
        try {
            Object[] args = invocation.getArgs();
            return invokeMethod.invoke(target, args);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Error in operation=" + operationName + " method=" + this.method + " target=" + target);
        }
        catch (Throwable t) {
            this.handleInvocationExceptions(t);
            return null;
        }
    }

    protected void handleInvocationExceptions(Throwable t) throws Throwable {
        if (t instanceof InvocationTargetException) {
            if ((t = ((InvocationTargetException)t).getTargetException()) instanceof RuntimeOperationsException) {
                throw (RuntimeOperationsException)t;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw t;
        }
        if (t instanceof Exception) {
            throw new ReflectionException((Exception)t);
        }
        if (t instanceof Error) {
            throw new RuntimeErrorException((Error)t);
        }
        throw t;
    }
}

