/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.common;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClassloadingUtility {
    private static final char BREAKCHARACTER = ';';

    public static <T> T loadAndInstantiateClass(Class<T> iface, String className, String environmentBeanInstanceName) {
        Class<?> clazz;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("Loading class " + className));
        }
        if (className == null) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_1();
            return null;
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_2(className, e);
            return null;
        }
        T instance = null;
        try {
            Class<T> clazz2 = clazz.asSubclass(iface);
            Constructor<?>[] ctors = clazz.getConstructors();
            Class<?> environmentBeanClass = null;
            for (Constructor<?> constructor : ctors) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].getCanonicalName().endsWith("EnvironmentBean")) continue;
                environmentBeanClass = constructor.getParameterTypes()[0];
                Object envBean = BeanPopulator.getNamedInstance(environmentBeanClass, environmentBeanInstanceName);
                instance = (T)constructor.newInstance(envBean);
                break;
            }
            if (environmentBeanClass == null && environmentBeanInstanceName == null) {
                instance = clazz2.newInstance();
            }
        }
        catch (ClassCastException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_3(className, iface.getName(), e);
        }
        catch (InstantiationException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_4(className, e);
        }
        catch (IllegalAccessException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_5(className, e);
        }
        catch (InvocationTargetException e) {
            tsLogger.i18NLogger.warn_common_ClassloadingUtility_4(className, e);
        }
        return instance;
    }

    public static <T> List<T> loadAndInstantiateClassesWithInit(Class<T> iface, List<String> classNamesWithOptionalInitParams) {
        ArrayList<T> instances = new ArrayList<T>();
        for (String theClassAndParameter : classNamesWithOptionalInitParams) {
            int breakPosition = theClassAndParameter.indexOf(59);
            String theClass = null;
            String theParameter = null;
            if (breakPosition != -1) {
                theClass = theClassAndParameter.substring(0, breakPosition);
                theParameter = theClassAndParameter.substring(breakPosition + 1);
            } else {
                theClass = theClassAndParameter;
            }
            T instance = ClassloadingUtility.loadAndInstantiateClass(iface, theClass, null);
            if (theClass != null && theParameter != null) {
                try {
                    Method method = instance.getClass().getMethod("initialise", String.class);
                    method.invoke(instance, theParameter);
                }
                catch (Exception e) {
                    tsLogger.i18NLogger.warn_common_ClassloadingUtility_6(theClassAndParameter, e);
                    continue;
                }
            }
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    public static String getNameForClass(Object instance) {
        if (instance == null) {
            return null;
        }
        return instance.getClass().getName();
    }

    public static List<String> getNamesForClasses(List<? extends Object> instances) {
        ArrayList<String> names = new ArrayList<String>();
        if (instances != null) {
            for (Object object : instances) {
                String name = ClassloadingUtility.getNameForClass(object);
                if (name == null) continue;
                names.add(name);
            }
        }
        return names;
    }
}

