/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.hibernate.SessionFactory;
import org.jboss.ejb3.annotation.IgnoreDependency;
import org.jboss.ejb3.entity.InjectedSessionFactory;
import org.jboss.injection.ExtendedInjectionContainer;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.PuEncInjector;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.deployment.PersistenceUnitDeployment;
import org.jboss.jpa.injection.InjectedEntityManagerFactory;
import org.jboss.jpa.spi.PersistenceUnitRegistry;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

public class PersistenceUnitHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static final Logger log = Logger.getLogger(PersistenceUnitHandler.class);
    public static final String ERROR_MESSAGE_FAILED_TO_RESOVLE_PU = " failed to resolve persistence unit ";

    @Override
    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getPersistenceUnitRefs() == null) {
            return;
        }
        for (PersistenceUnitReferenceMetaData ref : xml.getPersistenceUnitRefs()) {
            String encName = "env/" + ref.getPersistenceUnitRefName();
            Class<?> injectionType = InjectionUtil.injectionTarget(encName, (ResourceInjectionMetaData)ref, container, container.getEncInjections());
            if (container.getEncInjectors().containsKey(encName)) {
                return;
            }
            container.getEncInjectors().put(encName, new PuEncInjector(encName, injectionType, ref.getPersistenceUnitName(), "<persistence-unit-ref>"));
            try {
                PersistenceUnitHandler.addPUDependency(ref.getPersistenceUnitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal <persistence-unit-ref> of " + ref.getPersistenceUnitRefName() + " :" + e.getMessage());
            }
        }
    }

    @Override
    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        PersistenceUnit pu;
        PersistenceUnits resources = container.getAnnotation(PersistenceUnits.class, clazz);
        if (resources != null) {
            for (PersistenceUnit ref : resources.value()) {
                PersistenceUnitHandler.handleClassAnnotation(ref, container, clazz);
            }
        }
        if ((pu = container.getAnnotation(PersistenceUnit.class, clazz)) != null) {
            PersistenceUnitHandler.handleClassAnnotation(pu, container, clazz);
        }
    }

    private static void handleClassAnnotation(PersistenceUnit ref, InjectionContainer container, Class<?> clazz) {
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
        }
        encName = "env/" + encName;
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        container.getEncInjectors().put(encName, new PuEncInjector(encName, null, ref.unitName(), "@PersistenceUnit"));
        try {
            PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
        }
        catch (NameNotFoundException e) {
            throw new RuntimeException("Illegal @PersistenceUnit on " + clazz.getName() + " of unitname " + ref.unitName() + " :" + e.getMessage());
        }
    }

    public static void addPUDependency(String unitName, InjectionContainer container) throws NameNotFoundException {
        if (container instanceof ExtendedInjectionContainer) {
            ExtendedInjectionContainer eic = (ExtendedInjectionContainer)container;
            try {
                String dependency = eic.resolvePersistenceUnitSupplier(unitName);
                container.getDependencyPolicy().addDependency(dependency);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Container " + container + ERROR_MESSAGE_FAILED_TO_RESOVLE_PU + unitName, e);
            }
            return;
        }
        throw new UnsupportedOperationException("Container " + container + " does not implement ExtendedInjectionContainer, can't resolve persistence unit " + unitName);
    }

    public static ManagedEntityManagerFactory getManagedEntityManagerFactory(InjectionContainer container, String unitName) throws NameNotFoundException {
        if (container instanceof ExtendedInjectionContainer) {
            ExtendedInjectionContainer eic = (ExtendedInjectionContainer)container;
            String beanName = eic.resolvePersistenceUnitSupplier(unitName);
            return ((PersistenceUnitDeployment)PersistenceUnitRegistry.getPersistenceUnit((String)beanName)).getManagedFactory();
        }
        throw new UnsupportedOperationException("Container " + container + " does not implement ExtendedInjectionContainer, can't resolve persistence unit " + unitName);
    }

    public static EntityManagerFactory getEntityManagerFactory(PersistenceUnit ref, InjectionContainer container) throws NameNotFoundException {
        return PersistenceUnitHandler.getEntityManagerFactory(ref.unitName(), container);
    }

    public static Object getFactory(Class<?> type, String unitName, InjectionContainer container) throws NameNotFoundException {
        if (type != null && type.getName().equals(SessionFactory.class.getName())) {
            return PersistenceUnitHandler.getSessionFactory(unitName, container);
        }
        return PersistenceUnitHandler.getEntityManagerFactory(unitName, container);
    }

    public static EntityManagerFactory getEntityManagerFactory(String unitName, InjectionContainer container) throws NameNotFoundException {
        if (container instanceof ExtendedInjectionContainer) {
            ExtendedInjectionContainer eic = (ExtendedInjectionContainer)container;
            String beanName = eic.resolvePersistenceUnitSupplier(unitName);
            ManagedEntityManagerFactory managedFactory = ((PersistenceUnitDeployment)PersistenceUnitRegistry.getPersistenceUnit((String)beanName)).getManagedFactory();
            return new InjectedEntityManagerFactory(managedFactory);
        }
        throw new UnsupportedOperationException("Container " + container + " does not implement ExtendedInjectionContainer, can't resolve persistence unit " + unitName);
    }

    private static SessionFactory getSessionFactory(String ref, InjectionContainer container) throws NameNotFoundException {
        if (container instanceof ExtendedInjectionContainer) {
            ExtendedInjectionContainer eic = (ExtendedInjectionContainer)container;
            String beanName = eic.resolvePersistenceUnitSupplier(ref);
            ManagedEntityManagerFactory managedFactory = ((PersistenceUnitDeployment)PersistenceUnitRegistry.getPersistenceUnit((String)beanName)).getManagedFactory();
            return new InjectedSessionFactory(managedFactory);
        }
        throw new UnsupportedOperationException("Container " + container + " does not implement ExtendedInjectionContainer, can't resolve persistence unit " + ref);
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        PersistenceUnit ref = method.getAnnotation(PersistenceUnit.class);
        if (ref == null) {
            return;
        }
        if (!method.getName().startsWith("set")) {
            throw new RuntimeException("@PersistenceUnit can only be used with a set method: " + method);
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + encName;
        if (!container.getEncInjectors().containsKey(encName)) {
            container.getEncInjectors().put(encName, new PuEncInjector(encName, method.getParameterTypes()[0], ref.unitName(), "@PersistenceUnit"));
            try {
                if (!method.isAnnotationPresent(IgnoreDependency.class)) {
                    PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                }
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal @PersistenceUnit on " + method + " :" + e.getMessage());
            }
        }
        injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        PersistenceUnit ref = field.getAnnotation(PersistenceUnit.class);
        if (ref == null) {
            return;
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
        if (!container.getEncInjectors().containsKey(encName)) {
            container.getEncInjectors().put(encName, new PuEncInjector(encName, field.getType(), ref.unitName(), "@PersistenceUnit"));
            try {
                if (!field.isAnnotationPresent(IgnoreDependency.class)) {
                    PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                }
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal @PersistenceUnit on " + field + " :" + e.getMessage());
            }
        }
        injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
    }
}

