/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.kernel.plugins.annotations.InstallationParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Jsr330InjectFilter;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr330InjectMethodAnnotationPlugin
extends InstallationParameterAnnotationPlugin<Inject> {
    public Jsr330InjectMethodAnnotationPlugin(Map<Class<? extends Annotation>, Annotation2ValueMetaDataAdapter<? extends Annotation>> adapters) {
        super(Inject.class, adapters);
    }

    @Override
    protected List<InstallMetaData> getInstalls(BeanMetaData beanMetaData) {
        return beanMetaData.getInstalls();
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(MethodInfo info, MetaData retrieval, Inject annotation, KernelControllerContext context) throws Throwable {
        if (!Jsr330InjectFilter.INSTANCE.handleInject(retrieval)) {
            return null;
        }
        ParameterInfo[] params = info.getParameters();
        if (params.length == 0) {
            return null;
        }
        if (!(context.getBeanMetaData() instanceof AbstractBeanMetaData)) {
            throw new IllegalStateException("Bean meta data is not AbstractBeanMetaData");
        }
        AbstractBeanMetaData beanMetaData = (AbstractBeanMetaData)context.getBeanMetaData();
        List<InstallMetaData> installs = beanMetaData.getInstalls();
        if (installs == null) {
            installs = new ArrayList<InstallMetaData>();
            beanMetaData.setInstalls(installs);
        }
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setMethodName(info.getName());
        install.setState(ControllerState.CONFIGURED);
        install.setDependentState(ControllerState.INSTALLED);
        installs.add(install);
        List<ParameterMetaData> parameters = install.getParameters();
        if (parameters == null) {
            parameters = new ArrayList<ParameterMetaData>();
            install.setParameters(parameters);
        }
        for (int i = 0; i < params.length; ++i) {
            AbstractInjectionValueMetaData inject = new AbstractInjectionValueMetaData();
            AbstractParameterMetaData param = new AbstractParameterMetaData(params[i].getParameterType().getName(), inject);
            parameters.add(param);
        }
        return Collections.singletonList(install);
    }

    @Override
    protected void setParameterizedMetaData(AbstractInstallMetaData parameterizedMetaData, BeanMetaData beanMetaData) {
    }
}

