/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.scanning.plugins.helpers.MergeUtils;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.scanning.spi.helpers.ScanningHandleAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanningHandleAggregator<T extends ScanningHandle, U>
implements ScanningHandleAggregator<T, U> {
    protected U aggregate(final ScanningPlugin plugin, final Set<U> handles) {
        return (U)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{plugin.getHandleInterface()}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if ("toString".equals(methodName)) {
                    return plugin + ".handle-aggregate";
                }
                if ("getClass".equals(methodName)) {
                    return plugin.getHandleInterface();
                }
                if ("equals".equals(methodName)) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(methodName)) {
                    return proxy.hashCode();
                }
                Object result = null;
                for (Object handle : handles) {
                    Object tmp = method.invoke(handle, args);
                    if (tmp == null) continue;
                    if (tmp instanceof Collection) {
                        if (result == null) {
                            result = tmp;
                            continue;
                        }
                        ((Collection)result).addAll((Collection)tmp);
                        continue;
                    }
                    if (tmp instanceof Map) {
                        if (result == null) {
                            result = tmp;
                            continue;
                        }
                        MergeUtils.singleMerge((Map)result, (Map)tmp);
                        continue;
                    }
                    result = tmp;
                    break;
                }
                return result;
            }
        });
    }
}

