/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.Text;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    public SOAPBodyImpl(String prefix, String namespace) {
        super("Body", prefix, namespace);
    }

    @Override
    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof SOAPBodyElement)) {
            child = SOAPBodyImpl.convertToBodyElement((Node)child);
        }
        child = super.addChildElement(child);
        return child;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElementDoc child = new SOAPBodyElementDoc(name);
        return (SOAPBodyElement)this.addChildElement(child);
    }

    public SOAPBodyElement addBodyElement(QName qname) throws SOAPException {
        SOAPBodyElementDoc child = new SOAPBodyElementDoc(qname);
        return (SOAPBodyElement)this.addChildElement(child);
    }

    public SOAPBodyElement addDocument(Document doc) throws SOAPException {
        Element rootElement = doc.getDocumentElement();
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        SOAPElement soapElement = soapFactory.createElement(rootElement);
        return (SOAPBodyElement)this.addChildElement(soapElement);
    }

    public SOAPFault addFault() throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getPrefix(), this.getNamespaceURI());
        soapFault = (SOAPFaultImpl)this.addChildElement(soapFault);
        soapFault.setFaultCode(soapFault.getDefaultFaultCode());
        return soapFault;
    }

    public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getPrefix(), this.getNamespaceURI());
        soapFault = (SOAPFaultImpl)this.addChildElement(soapFault);
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString);
        return soapFault;
    }

    public SOAPFault addFault(QName faultCode, String faultString) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getPrefix(), this.getNamespaceURI());
        soapFault = (SOAPFaultImpl)this.addChildElement(soapFault);
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString);
        return soapFault;
    }

    public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getPrefix(), this.getNamespaceURI());
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString, locale);
        this.addChildElement(soapFault);
        return soapFault;
    }

    public SOAPFault addFault(QName faultCode, String faultString, Locale locale) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getPrefix(), this.getNamespaceURI());
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString, locale);
        this.addChildElement(soapFault);
        return soapFault;
    }

    public SOAPFault getFault() {
        Iterator it = this.faultIterator();
        SOAPFault soapFault = it.hasNext() ? (SOAPFault)it.next() : null;
        return soapFault;
    }

    public boolean hasFault() {
        return this.faultIterator().hasNext();
    }

    private Iterator faultIterator() {
        return this.getChildElements(new QName(this.getNamespaceURI(), "Fault"));
    }

    public SOAPBodyElement getBodyElement() {
        SOAPBodyElement bodyElement = null;
        Iterator<Node> it = this.getChildElements();
        while (bodyElement == null && it.hasNext()) {
            Node next = it.next();
            if (!(next instanceof SOAPBodyElement)) continue;
            bodyElement = (SOAPBodyElement)next;
        }
        return bodyElement;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (SOAPBodyImpl.needsConversionToBodyElement((Node)newChild)) {
            newChild = SOAPBodyImpl.convertToBodyElement((Node)newChild);
        }
        return super.appendChild((Node)newChild);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (SOAPBodyImpl.needsConversionToBodyElement((Node)newChild)) {
            newChild = SOAPBodyImpl.convertToBodyElement((Node)newChild);
        }
        return super.insertBefore((Node)newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (SOAPBodyImpl.needsConversionToBodyElement((Node)newChild)) {
            newChild = SOAPBodyImpl.convertToBodyElement((Node)newChild);
        }
        return super.replaceChild((Node)newChild, oldChild);
    }

    @Override
    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        String envNamespace = this.getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace) && name.equals(new NameImpl("encodingStyle", "env", envNamespace))) {
            throw new SOAPException("Cannot set encodingStyle on: " + this.getElementQName());
        }
        return super.addAttribute(name, value);
    }

    public Document extractContentAsDocument() throws SOAPException {
        Node current;
        Iterator<Node> childElements = this.getChildElements();
        SOAPElementImpl childElement = null;
        while (childElements.hasNext()) {
            current = childElements.next();
            if (!(current instanceof SOAPElementImpl)) continue;
            childElement = (SOAPElementImpl)((Object)current);
            break;
        }
        if (childElement == null) {
            throw new SOAPException("Cannot find SOAPBodyElement");
        }
        while (childElements.hasNext()) {
            current = childElements.next();
            if (!(current instanceof SOAPElementImpl)) continue;
            throw new SOAPException("Multiple SOAPBodyElement");
        }
        if (childElement instanceof SOAPContentElement) {
            SOAPContentElement contentElement = (SOAPContentElement)childElement;
            contentElement.hasChildNodes();
        }
        childElement.detachNode();
        Document newDocument = DOMUtils.getDocumentBuilder().newDocument();
        Node adoptedElement = newDocument.adoptNode(childElement.domNode);
        newDocument.appendChild(adoptedElement);
        return newDocument;
    }

    private static boolean needsConversionToBodyElement(Node newChild) {
        boolean validChild = newChild instanceof SOAPBodyElement;
        validChild = validChild || newChild instanceof DocumentFragment;
        validChild = validChild || newChild instanceof Text;
        validChild = validChild || newChild instanceof Comment;
        return !validChild;
    }

    private static SOAPBodyElementDoc convertToBodyElement(Node node) {
        if (!(node instanceof SOAPElementImpl)) {
            throw new IllegalArgumentException("SOAPElement expected");
        }
        SOAPElementImpl element = (SOAPElementImpl)((Object)node);
        element.detachNode();
        return new SOAPBodyElementDoc(element);
    }
}

