/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.virtual;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.profileservice.config.VirtualAssemblyConfiguration;
import org.jboss.profileservice.repository.artifact.ArtifactRepositoryManager;
import org.jboss.profileservice.repository.virtual.AbstractVirtualDeploymentRepository;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VirtualFile;

public class DelegatingDeploymentRepository
extends AbstractVirtualDeploymentRepository
implements VirtualDeploymentRepository {
    private Map<String, ArtifactRepositoryId> repositoryRefs = new HashMap<String, ArtifactRepositoryId>();
    private final ArtifactRepositoryManager repositoryManager;
    private final VirtualAssemblyConfiguration assemblyConfiguration;

    public DelegatingDeploymentRepository(ArtifactRepositoryManager repositoryManager, VirtualAssemblyConfiguration configuration, ArtifactRepositoryId ... repositoryIds) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException("null repository manager");
        }
        this.processMappings(repositoryIds);
        this.assemblyConfiguration = configuration;
        this.repositoryManager = repositoryManager;
    }

    @Override
    protected VirtualFile getAssembledRoot() {
        return this.assemblyConfiguration.getVirtualAssemblyRoot();
    }

    public Collection<ArtifactRepositoryId> getRepositoryIDs() {
        return this.repositoryRefs.values();
    }

    public Collection<ArtifactRepository<ArtifactId>> getArtifactRepositories() {
        HashSet<ArtifactRepository<ArtifactId>> repositories = new HashSet<ArtifactRepository<ArtifactId>>();
        for (ArtifactRepositoryId id : this.repositoryRefs.values()) {
            ArtifactRepository<ArtifactId> artifactRepository = this.resolveRepository(id);
            repositories.add(artifactRepository);
        }
        return repositories;
    }

    public ArtifactRepository<ArtifactId> resolveArtifactRepository(ArtifactId artifactId) {
        return this.resolveRepository(artifactId);
    }

    @Override
    protected VirtualDeploymentRepository getDeploymentRepository() {
        return this;
    }

    @Override
    public ArtifactRepository<ArtifactId> resolveRepository(ArtifactId artifactId) {
        ArtifactRepositoryId repositoryId = this.resolveRepositoryId(artifactId);
        return this.resolveRepository(repositoryId);
    }

    protected ArtifactRepositoryId resolveRepositoryId(ArtifactId artifact) {
        ArtifactRepositoryId reference = this.repositoryRefs.get(artifact.getType());
        if (reference == null) {
            throw new IllegalArgumentException("failed to find artifact repository reference for " + artifact);
        }
        return reference;
    }

    protected ArtifactRepository<ArtifactId> resolveRepository(ArtifactRepositoryId repositoryId) {
        ArtifactRepository<ArtifactId> repository = this.repositoryManager.getArtifactRepository(repositoryId);
        if (repository == null) {
            throw new IllegalStateException("failed to find repository for repository reference " + repositoryId);
        }
        return repository;
    }

    protected void processMappings(ArtifactRepositoryId ... ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("no repository mappings");
        }
        for (ArtifactRepositoryId id : ids) {
            this.repositoryRefs.put(id.getType(), id);
        }
    }
}

