/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.helpers;

import java.nio.channels.Channel;
import java.util.concurrent.Executor;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelListenerService<T extends Channel> {
    private final ChannelListener<T> listener;
    private final ChannelListener.Setter<T> setter;
    private final Executor executor;

    public ChannelListenerService(ChannelListener<T> listener, ChannelListener.Setter<T> setter, Executor executor) {
        this.listener = listener;
        this.setter = setter;
        this.executor = executor;
    }

    public void start() {
        Executor executor = this.executor;
        this.setter.set(executor != null ? new ChannelListener<T>(){

            public void handleEvent(T channel) {
                ChannelListenerService.this.executor.execute(IoUtils.getChannelListenerTask(channel, (ChannelListener)ChannelListenerService.this.listener));
            }
        } : this.listener);
    }

    public void stop() {
        this.setter.set(null);
    }
}

