/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;
import org.jboss.shrinkwrap.impl.base.container.SecurityActions;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerBase<T extends Archive<T>>
extends AssignableBase
implements Archive<T>,
ManifestContainer<T>,
ResourceContainer<T>,
ClassContainer<T>,
LibraryContainer<T> {
    private final Archive<?> archive;
    private final Class<T> actualType;

    protected ContainerBase(Class<T> actualType, Archive<?> archive) {
        Validate.notNull(actualType, "ActualType should be specified");
        Validate.notNull(archive, "Archive should be specified");
        this.actualType = actualType;
        this.archive = archive;
    }

    public T add(Archive<?> archive, String path) {
        this.archive.add(archive, path);
        return this.covarientReturn();
    }

    public T add(Archive<?> archive, ArchivePath path) {
        this.archive.add(archive, path);
        return this.covarientReturn();
    }

    public T add(Asset asset, ArchivePath target) throws IllegalArgumentException {
        this.archive.add(asset, target);
        return this.covarientReturn();
    }

    public T add(Asset asset, ArchivePath path, String name) {
        this.archive.add(asset, path, name);
        return this.covarientReturn();
    }

    public T add(Asset asset, String target, String name) throws IllegalArgumentException {
        this.archive.add(asset, target, name);
        return this.covarientReturn();
    }

    public T addDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        this.archive.addDirectories(paths);
        return this.covarientReturn();
    }

    public T addDirectories(String ... paths) throws IllegalArgumentException {
        this.archive.addDirectories(paths);
        return this.covarientReturn();
    }

    public T addDirectory(ArchivePath path) throws IllegalArgumentException {
        this.archive.addDirectory(path);
        return this.covarientReturn();
    }

    public T addDirectory(String path) throws IllegalArgumentException {
        this.archive.addDirectory(path);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        this.archive.merge(source);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.archive.merge(source, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        this.archive.merge(source, path);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.archive.merge(source, path, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.archive.merge(source, path, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, String path) throws IllegalArgumentException {
        this.archive.merge(source, path);
        return this.covarientReturn();
    }

    public T add(Asset asset, String name) {
        this.archive.add(asset, name);
        return this.covarientReturn();
    }

    public boolean contains(ArchivePath path) {
        return this.archive.contains(path);
    }

    public boolean contains(String path) throws IllegalArgumentException {
        Validate.notNull(path, "Path must be specified");
        return this.contains(ArchivePaths.create((String)path));
    }

    public boolean delete(ArchivePath path) {
        return this.archive.delete(path);
    }

    public Node get(ArchivePath path) {
        return this.archive.get(path);
    }

    public Node get(String path) throws IllegalArgumentException {
        return this.archive.get(path);
    }

    public Map<ArchivePath, Node> getContent() {
        return this.archive.getContent();
    }

    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> filter) {
        return this.archive.getContent(filter);
    }

    public String getName() {
        return this.archive.getName();
    }

    public String toString() {
        return this.archive.toString();
    }

    public String toString(boolean verbose) {
        return this.archive.toString(verbose);
    }

    public String toString(Formatter formatter) throws IllegalArgumentException {
        return this.archive.toString(formatter);
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    protected abstract ArchivePath getManifestPath();

    public final T setManifest(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setManifest(new ClassLoaderAsset(resourceName));
    }

    public T setManifest(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest((Asset)new FileAsset(resource));
    }

    public T setManifest(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest((Asset)new UrlAsset(resource));
    }

    public T setManifest(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(resource, "MANIFEST.MF");
    }

    public final T addManifestResource(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addManifestResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addManifestResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addManifestResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addManifestResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new FileAsset(resource), target);
    }

    public T addManifestResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addManifestResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addManifestResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addManifestResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new FileAsset(resource), target);
    }

    public T addManifestResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addManifestResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getManifestPath(), target);
        return this.add(resource, (ArchivePath)location);
    }

    public T addManifestResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addManifestResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addManifestResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addManifestResource(resourcePackage, resourceName, target);
    }

    public T addManifestResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addManifestResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addManifestResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addManifestResource((Asset)resource, target);
    }

    public T addServiceProvider(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        ServiceProviderAsset asset = new ServiceProviderAsset(serviceImpls);
        BasicPath path = new BasicPath("services", serviceInterface.getName());
        return this.addManifestResource((Asset)asset, (ArchivePath)path);
    }

    protected abstract ArchivePath getResourcePath();

    public final T addResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public final T addResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource((Asset)new FileAsset(resource), resource.getName());
    }

    public final T addResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new FileAsset(resource), target);
    }

    public T addResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new UrlAsset(resource), target);
    }

    public T addResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addResource(String resourceName, ArchivePath target, ClassLoader classLoader) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(classLoader, "ClassLoader should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName, classLoader), target);
    }

    public T addResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new FileAsset(resource), target);
    }

    public T addResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new UrlAsset(resource), target);
    }

    public T addResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getResourcePath(), target);
        return this.add(resource, (ArchivePath)location);
    }

    public T addResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addResource(resourcePackage, resourceName, target);
    }

    public T addResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addResource((Asset)resource, target);
    }

    protected abstract ArchivePath getClassesPath();

    public T addClass(Class<?> clazz) throws IllegalArgumentException {
        Validate.notNull(clazz, "Clazz must be specified");
        return this.addClasses(clazz);
    }

    public T addClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        Validate.notNullOrEmpty(fullyQualifiedClassName, "Fully-qualified class name must be specified");
        return this.addClass(fullyQualifiedClassName, AccessController.doPrivileged(GetTcclAction.INSTANCE));
    }

    public T addClass(String fullyQualifiedClassName, ClassLoader cl) throws IllegalArgumentException {
        Class<?> clazz;
        Validate.notNullOrEmpty(fullyQualifiedClassName, "Fully-qualified class name must be specified");
        Validate.notNull(cl, "ClassLoader must be specified");
        try {
            clazz = Class.forName(fullyQualifiedClassName, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class of name " + fullyQualifiedClassName + " with " + cl, e);
        }
        return this.addClass(clazz);
    }

    public T addClasses(Class<?> ... classes) throws IllegalArgumentException {
        Validate.notNull(classes, "Classes must be specified");
        for (final Class<?> clazz : classes) {
            ClassAsset resource = new ClassAsset(clazz);
            BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
            this.add((Asset)resource, (ArchivePath)location);
            this.addPackages(false, new Filter<ArchivePath>(){

                public boolean include(ArchivePath path) {
                    ArchivePath classArchivePath = AssetUtil.getFullPathForClassResource(clazz);
                    String expression = classArchivePath.get().replace(".class", "\\$.*");
                    return path.get().matches(expression);
                }
            }, clazz.getPackage());
        }
        return this.covarientReturn();
    }

    public T addPackage(Package pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Pack must be specified");
        return this.addPackages(false, pack);
    }

    public T addPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(packages, "Packages must be specified");
        return this.addPackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T addPackages(boolean recursive, final Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(packages, "Packages must be specified");
        final ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
        for (Package pack : packages) {
            URLPackageScanner.Callback callback = new URLPackageScanner.Callback(){

                public void classFound(String className) {
                    Class<?> clazz;
                    ArchivePath classNamePath = AssetUtil.getFullPathForClassResource(className);
                    if (!filter.include((Object)classNamePath)) {
                        return;
                    }
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Could not load found class " + className, e);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new RuntimeException("Could not load found class " + className, e);
                    }
                    ClassAsset asset = new ClassAsset(clazz);
                    BasicPath location = new BasicPath(ContainerBase.this.getClassesPath(), classNamePath);
                    ContainerBase.this.add((Asset)asset, (ArchivePath)location);
                }
            };
            URLPackageScanner scanner = pack == null ? URLPackageScanner.newInstance(recursive, classLoader, callback) : URLPackageScanner.newInstance(recursive, classLoader, callback, pack);
            scanner.scanPackage();
        }
        return this.covarientReturn();
    }

    protected abstract ArchivePath getLibraryPath();

    public T addLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getLibraryPath());
    }

    public T addLibrary(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addLibrary((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addLibrary(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary((Asset)new FileAsset(resource), resource.getName());
    }

    public T addLibrary(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addLibrary(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new FileAsset(resource), target);
    }

    public T addLibrary(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new UrlAsset(resource), target);
    }

    public T addLibrary(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary(resource, (ArchivePath)new BasicPath(target));
    }

    public T addLibrary(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addLibrary(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new FileAsset(resource), target);
    }

    public T addLibrary(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new UrlAsset(resource), target);
    }

    public T addLibrary(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getLibraryPath(), target);
        return this.add(resource, (ArchivePath)location);
    }

    public T addLibraries(String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourceNames, "ResourceNames must be specified");
        for (String resourceName : resourceNames) {
            this.addLibrary(resourceName);
        }
        return this.covarientReturn();
    }

    public T addLibraries(File ... resources) throws IllegalArgumentException {
        Validate.notNull(resources, "Resources must be specified");
        for (File resource : resources) {
            this.addLibrary(resource);
        }
        return this.covarientReturn();
    }

    public T addLibraries(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, "Archives must be specified");
        for (Archive<?> archive : archives) {
            this.addLibrary(archive);
        }
        return this.covarientReturn();
    }

    protected T covarientReturn() {
        return (T)((Archive)this.getActualClass().cast(this));
    }

    protected Class<T> getActualClass() {
        return this.actualType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

