/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.bean.history.operation;

import java.util.Date;
import org.jboss.on.embedded.manager.history.operation.OperationHistoryManager;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.util.exception.ExceptionPackage;

public class OperationServerServiceImpl
implements OperationServerService {
    private OperationHistoryManager historyBean;

    public OperationHistoryManager getHistoryBean() {
        return this.historyBean;
    }

    public void setHistoryBean(OperationHistoryManager historyBean) {
        this.historyBean = historyBean;
    }

    public void operationSucceeded(String jobId, Configuration results, long invocationTime, long completionTime) {
        OperationHistory history = (OperationHistory)this.historyBean.getHistory(jobId);
        history.setStatus(OperationRequestStatus.SUCCESS);
        if (history instanceof ResourceOperationHistory) {
            if (results != null) {
                results.setId(history.getId());
            }
            ((ResourceOperationHistory)history).setResults(results);
        }
    }

    public void operationFailed(String jobId, Configuration results, ExceptionPackage error, long invocationTime, long completionTime) {
        OperationHistory operationHistory = (OperationHistory)this.historyBean.getHistory(jobId);
        operationHistory.setStatus(OperationRequestStatus.FAILURE);
        if (operationHistory instanceof ResourceOperationHistory) {
            if (results != null) {
                results.setId(operationHistory.getId());
            }
            ((ResourceOperationHistory)operationHistory).setResults(results);
        }
        if (error != null) {
            if (error.getExceptionName().equals(UnsupportedOperationException.class.getName())) {
                operationHistory.setErrorMessage("The '" + operationHistory.getOperationDefinition().getName() + "' operation is not supported by Embedded Jopr: " + error.getMessage());
            } else {
                operationHistory.setErrorMessage(error.getStackTraceString());
            }
        } else {
            operationHistory.setErrorMessage("Failed for an unknown reason at " + new Date(completionTime));
        }
    }

    public void operationTimedOut(String jobId, long invocationTime, long timeoutTime) {
        OperationHistory history = (OperationHistory)this.historyBean.getHistory(jobId);
        if (history.getStatus() == OperationRequestStatus.INPROGRESS) {
            history.setStatus(OperationRequestStatus.FAILURE);
            history.setErrorMessage("Timed Out");
        }
    }
}

