/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.classloading.spi.visitor.RootAwareResource;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.classloading.ResourceLookupProvider;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceLookupDeployer
extends AbstractSimpleRealDeployer<Module>
implements ResourceLookupProvider<Module> {
    private String resourceName;
    private String[] dir;
    private Map<Module, Set<URL>> matchingModules;
    private AtomicBoolean active = new AtomicBoolean(true);

    public AbstractResourceLookupDeployer(String resourceName) {
        super(Module.class);
        if (resourceName == null) {
            throw new IllegalArgumentException("Null resource name");
        }
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.resourceName = resourceName;
        int p = resourceName.lastIndexOf("/");
        if (p > 0) {
            String dirs = resourceName.substring(0, p);
            this.dir = dirs.split("/");
        } else {
            this.dir = new String[0];
        }
        this.matchingModules = new ConcurrentHashMap<Module, Set<URL>>();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Map<Module, Set<URL>> getMatchingModules() {
        return Collections.unmodifiableMap(this.matchingModules);
    }

    public void deploy(DeploymentUnit unit, Module module) throws DeploymentException {
        if (!this.active.get()) {
            return;
        }
        MapperRV rv = new MapperRV();
        module.visit((ResourceVisitor)rv, rv.getFilter(), (ResourceFilter)new MapperRF(), new URL[0]);
        if (!rv.owners.isEmpty()) {
            this.matchingModules.put(module, rv.owners);
        }
    }

    public void undeploy(DeploymentUnit unit, Module module) {
        this.matchingModules.remove(module);
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    private class MapperRF
    implements ResourceFilter {
        private MapperRF() {
        }

        public boolean accepts(ResourceContext resource) {
            if (AbstractResourceLookupDeployer.this.dir.length == 0) {
                return false;
            }
            String name = resource.getResourceName();
            String[] split = name.split("/");
            int sl = split.length;
            int min = Math.min(sl, AbstractResourceLookupDeployer.this.dir.length);
            for (int i = 1; i <= min; ++i) {
                boolean match = true;
                for (int j = 0; j < i; ++j) {
                    if (AbstractResourceLookupDeployer.this.dir[j].equals(split[sl - i + j])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return true;
            }
            return false;
        }
    }

    private class MapperRV
    implements ResourceVisitor {
        private Set<URL> owners = new HashSet<URL>();

        private MapperRV() {
        }

        public ResourceFilter getFilter() {
            return new ResourceFilter(){

                public boolean accepts(ResourceContext resource) {
                    String name = resource.getResourceName();
                    return name.endsWith(AbstractResourceLookupDeployer.this.resourceName);
                }
            };
        }

        public void visit(ResourceContext resource) {
            if (resource instanceof RootAwareResource) {
                RootAwareResource rar = (RootAwareResource)resource;
                this.owners.add(rar.getRootUrl());
            }
        }
    }
}

