/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.socketfactory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.util.SecurityUtility;

public class CreationListenerServerSocket
extends ServerSocket {
    private ServerSocket serverSocket;
    private SocketCreationListener listener;
    private PrivilegedExceptionAction action;

    public CreationListenerServerSocket(ServerSocket serverSocket, SocketCreationListener listener) throws IOException {
        this.serverSocket = serverSocket;
        this.listener = listener;
        this.action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return CreationListenerServerSocket.this.serverSocket.accept();
            }
        };
    }

    public SocketCreationListener getListener() {
        return this.listener;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setListener(SocketCreationListener listener) {
        this.listener = listener;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        CreationListenerServerSocket.bind(this.serverSocket, endpoint);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        CreationListenerServerSocket.bind(this.serverSocket, endpoint, backlog);
    }

    @Override
    public Socket accept() throws IOException {
        Socket socket = null;
        if (SecurityUtility.skipAccessControl()) {
            socket = this.serverSocket.accept();
        } else {
            try {
                socket = (Socket)AccessController.doPrivileged(this.action);
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
        }
        this.listener.socketCreated(socket, this.serverSocket);
        return socket;
    }

    @Override
    public void close() throws IOException {
        this.serverSocket.close();
    }

    public boolean equals(Object obj) {
        return this.serverSocket.equals(obj);
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.serverSocket.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.serverSocket.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    public int hashCode() {
        return this.serverSocket.hashCode();
    }

    @Override
    public boolean isBound() {
        return this.serverSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.serverSocket.setReuseAddress(on);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.serverSocket.setSoTimeout(timeout);
    }

    @Override
    public String toString() {
        return this.serverSocket.toString();
    }

    private static void bind(final ServerSocket ss, final SocketAddress address) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            ss.bind(address);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ss.bind(address);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static void bind(final ServerSocket ss, final SocketAddress address, final int backlog) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            ss.bind(address, backlog);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ss.bind(address, backlog);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

