/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, S>
extends RIBean<T> {
    private static final Annotation ANY_LITERAL = new AnyLiteral();
    private static final Annotation CURRENT_LITERAL = new DefaultLiteral();
    private boolean proxyable;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected Set<Annotation> bindings;
    protected String name;
    protected Class<? extends Annotation> scopeType;
    private MergedStereotypes<T, S> mergedStereotypes;
    protected boolean alternative;
    protected Class<T> type;
    protected Set<Type> types;
    private Set<WeldInjectionPoint<?, ?>> injectionPoints;
    private Set<WeldInjectionPoint<?, ?>> delegateInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> newInjectionPoints;
    private boolean primitive;
    protected BeanManagerImpl manager;
    private boolean initialized;

    protected boolean isInitialized() {
        return this.initialized;
    }

    public AbstractBean(String idSuffix, BeanManagerImpl manager) {
        super(idSuffix, manager);
        this.manager = manager;
        this.injectionPoints = new HashSet();
        this.delegateInjectionPoints = new HashSet();
        this.newInjectionPoints = new HashSet();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (this.isSpecializing()) {
            this.preSpecialize(environment);
            this.specialize(environment);
            this.postSpecialize();
        }
        this.initDefaultBindings();
        this.initPrimitive();
        log.trace((Enum)BeanMessage.CREATING_BEAN, new Object[]{this.getType()});
        this.initName();
        this.initScopeType();
        this.initProxyable();
        this.checkDelegateInjectionPoints();
    }

    protected void initStereotypes() {
        this.mergedStereotypes = new MergedStereotypes(this.getAnnotatedItem().getMetaAnnotations(Stereotype.class), this.manager);
    }

    protected void checkDelegateInjectionPoints() {
        if (this.delegateInjectionPoints.size() > 0) {
            throw new DefinitionException(BeanMessage.DELEGATE_NOT_ON_DECORATOR, this);
        }
    }

    protected void addInjectionPoint(WeldInjectionPoint<?, ?> injectionPoint) {
        if (injectionPoint.isAnnotationPresent(Delegate.class)) {
            this.delegateInjectionPoints.add(injectionPoint);
        }
        if (injectionPoint.isAnnotationPresent(New.class)) {
            this.newInjectionPoints.add(injectionPoint);
        }
        this.injectionPoints.add(injectionPoint);
    }

    protected void addInjectionPoints(Iterable<? extends WeldInjectionPoint<?, ?>> injectionPoints) {
        for (WeldInjectionPoint<?, ?> injectionPoint : injectionPoints) {
            this.addInjectionPoint(injectionPoint);
        }
    }

    protected Set<WeldInjectionPoint<?, ?>> getDelegateInjectionPoints() {
        return this.delegateInjectionPoints;
    }

    protected void initTypes() {
        if (this.getAnnotatedItem().isAnnotationPresent(Typed.class)) {
            this.types = AbstractBean.getTypedTypes(this.getAnnotatedItem().getTypeClosureAsMap(), this.getAnnotatedItem().getJavaClass(), (Typed)this.getAnnotatedItem().getAnnotation(Typed.class));
        } else {
            this.types = this.getAnnotatedItem().getTypeClosure();
            if (this.getType().isInterface()) {
                this.types.add((Type)((Object)Object.class));
            }
        }
    }

    protected static Set<Type> getTypedTypes(Map<Class<?>, Type> typeClosure, Class<?> rawType, Typed typed) {
        HashSet<Type> types = new HashSet<Type>();
        for (Class specifiedClass : typed.value()) {
            if (!typeClosure.containsKey(specifiedClass)) {
                throw new DefinitionException(BeanMessage.TYPED_CLASS_NOT_IN_HIERARCHY, specifiedClass.getName(), rawType);
            }
            types.add(typeClosure.get(specifiedClass));
        }
        types.add((Type)((Object)Object.class));
        return types;
    }

    protected void initBindings() {
        this.bindings = new HashSet<Annotation>();
        this.bindings.addAll(this.getAnnotatedItem().getMetaAnnotations(Qualifier.class));
        this.initDefaultBindings();
        log.trace((Enum)BeanMessage.QUALIFIERS_USED, new Object[]{this.bindings, this});
    }

    protected void initDefaultBindings() {
        if (this.bindings.size() == 0) {
            log.trace((Enum)BeanMessage.USING_DEFAULT_QUALIFIER, new Object[]{this});
            this.bindings.add(CURRENT_LITERAL);
        }
        if (this.bindings.size() == 1 && this.bindings.iterator().next().annotationType().equals(Named.class)) {
            log.trace((Enum)BeanMessage.USING_DEFAULT_QUALIFIER, new Object[]{this});
            this.bindings.add(CURRENT_LITERAL);
        }
        this.bindings.add(ANY_LITERAL);
    }

    protected void initAlternative() {
        this.alternative = Beans.isAlternative(this.getAnnotatedItem(), this.getMergedStereotypes());
    }

    protected void initName() {
        boolean beanNameDefaulted = false;
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class)) {
            String javaName = ((Named)this.getAnnotatedItem().getAnnotation(Named.class)).value();
            if ("".equals(javaName)) {
                beanNameDefaulted = true;
            } else {
                log.trace((Enum)BeanMessage.USING_NAME, new Object[]{javaName, this});
                this.name = javaName;
                return;
            }
        }
        if (beanNameDefaulted || this.getMergedStereotypes().isBeanNameDefaulted()) {
            this.name = this.getDefaultName();
            log.trace((Enum)BeanMessage.USING_DEFAULT_NAME, new Object[]{this.name, this});
            return;
        }
    }

    protected void initProxyable() {
        this.proxyable = this.getAnnotatedItem().isProxyable();
    }

    protected void initPrimitive() {
        this.primitive = Reflections.isPrimitive(this.getType());
    }

    private boolean checkInjectionPointsAreSerializable() {
        boolean passivating = ((MetaAnnotationStore)this.manager.getServices().get(MetaAnnotationStore.class)).getScopeModel(this.getScope()).isPassivating();
        for (WeldInjectionPoint<?, ?> injectionPoint : this.getAnnotatedInjectionPoints()) {
            Annotation[] bindings = injectionPoint.getMetaAnnotationsAsArray(Qualifier.class);
            Bean<?> resolvedBean = this.manager.getBeans(injectionPoint.getJavaClass(), bindings).iterator().next();
            if (!passivating || !Dependent.class.equals((Object)resolvedBean.getScope()) || Reflections.isSerializable(resolvedBean.getBeanClass()) || (!(injectionPoint instanceof WeldField) || ((WeldField)((Object)injectionPoint)).isTransient()) && !(injectionPoint instanceof WeldParameter)) continue;
            return false;
        }
        return true;
    }

    protected abstract void initScopeType();

    protected boolean initScopeTypeFromStereotype() {
        Set<Annotation> possibleScopeTypes = this.getMergedStereotypes().getPossibleScopeTypes();
        if (possibleScopeTypes.size() == 1) {
            this.scopeType = possibleScopeTypes.iterator().next().annotationType();
            log.trace((Enum)BeanMessage.USING_SCOPE_FROM_STEREOTYPE, new Object[]{this.scopeType, this, this.getMergedStereotypes()});
            return true;
        }
        if (possibleScopeTypes.size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_SCOPES_FOUND_FROM_STEREOTYPES, this.getAnnotatedItem());
        }
        return false;
    }

    protected void postSpecialize() {
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class) && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            throw new DefinitionException(BeanMessage.NAME_NOT_ALLOWED_ON_SPECIALIZATION, this.getAnnotatedItem());
        }
        this.bindings.addAll(((AbstractBean)this.getSpecializedBean()).getQualifiers());
        if (this.isSpecializing() && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            this.name = ((AbstractBean)this.getSpecializedBean()).getName();
        }
        this.manager.getSpecializedBeans().put((Contextual<?>)this.getSpecializedBean(), (Contextual<?>)this);
    }

    protected void preSpecialize(BeanDeployerEnvironment environment) {
    }

    protected void specialize(BeanDeployerEnvironment environment) {
    }

    public abstract WeldAnnotated<T, S> getAnnotatedItem();

    public Set<Annotation> getQualifiers() {
        return this.bindings;
    }

    protected abstract String getDefaultName();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    @Override
    public Set<WeldInjectionPoint<?, ?>> getAnnotatedInjectionPoints() {
        return this.injectionPoints;
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return this.newInjectionPoints;
    }

    protected MergedStereotypes<T, S> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isNullable() {
        return !this.isPrimitive();
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScope());
    }

    public boolean isNormalScoped() {
        return ((MetaAnnotationStore)Container.instance().deploymentServices().get(MetaAnnotationStore.class)).getScopeModel(this.getScope()).isNormal();
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    @Override
    public boolean isSpecializing() {
        return this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.mergedStereotypes.getStereotypes();
    }
}

