/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Lifecycle;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.context.AbstractApplicationContext;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.SessionContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.slf4j.cal10n.LocLogger;

public class ContextLifecycle
implements Lifecycle,
Service {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final AbstractApplicationContext applicationContext;
    private final AbstractApplicationContext singletonContext;
    private final SessionContext sessionContext;
    private final ConversationContext conversationContext;
    private final RequestContext requestContext;
    private final DependentContext dependentContext;

    public ContextLifecycle(AbstractApplicationContext applicationContext, AbstractApplicationContext singletonContext, SessionContext sessionContext, ConversationContext conversationContext, RequestContext requestContext, DependentContext dependentContext) {
        this.applicationContext = applicationContext;
        this.singletonContext = singletonContext;
        this.sessionContext = sessionContext;
        this.conversationContext = conversationContext;
        this.requestContext = requestContext;
        this.dependentContext = dependentContext;
    }

    public void restoreSession(String id, BeanStore sessionBeanStore) {
        log.trace((Enum)ContextMessage.SESSION_RESTORED, new Object[]{id});
        this.sessionContext.setBeanStore(sessionBeanStore);
        this.sessionContext.setActive(true);
    }

    public void endSession(String id, BeanStore sessionBeanStore) {
        log.trace((Enum)ContextMessage.SESSION_ENDED, new Object[]{id});
        this.sessionContext.setActive(true);
        this.sessionContext.destroy();
        this.sessionContext.setBeanStore(null);
        this.sessionContext.setActive(false);
    }

    public void beginRequest(String id, BeanStore requestBeanStore) {
        log.trace((Enum)ContextMessage.REQUEST_STARTED, new Object[]{id});
        this.requestContext.setBeanStore(requestBeanStore);
        this.requestContext.setActive(true);
        this.dependentContext.setActive(true);
    }

    public void endRequest(String id, BeanStore requestBeanStore) {
        log.trace((Enum)ContextMessage.REQUEST_ENDED, new Object[]{id});
        this.requestContext.setBeanStore(requestBeanStore);
        this.dependentContext.setActive(false);
        this.requestContext.destroy();
        this.requestContext.setActive(false);
        this.requestContext.setBeanStore(null);
    }

    public boolean isRequestActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.requestContext.isActive() && this.dependentContext.isActive();
    }

    public boolean isApplicationActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.dependentContext.isActive();
    }

    public boolean isConversationActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.sessionContext.isActive() && this.conversationContext.isActive() && this.dependentContext.isActive();
    }

    public boolean isSessionActive() {
        return this.singletonContext.isActive() && this.applicationContext.isActive() && this.sessionContext.isActive() && this.dependentContext.isActive();
    }

    public void beginApplication(BeanStore applicationBeanStore) {
        log.trace((Enum)ContextMessage.APPLICATION_STARTED, new Object[]{""});
        this.applicationContext.setBeanStore(applicationBeanStore);
        this.applicationContext.setActive(true);
        this.singletonContext.setBeanStore((BeanStore)new ConcurrentHashMapBeanStore());
        this.singletonContext.setActive(true);
    }

    public void endApplication() {
        log.trace((Enum)ContextMessage.APPLICATION_ENDED, new Object[]{""});
        this.applicationContext.destroy();
        this.applicationContext.setActive(false);
        this.applicationContext.setBeanStore(null);
        this.singletonContext.destroy();
        this.singletonContext.setActive(false);
        this.singletonContext.setBeanStore(null);
        Container.instance().cleanup();
    }

    public void cleanup() {
        this.dependentContext.cleanup();
        this.requestContext.cleanup();
        this.conversationContext.cleanup();
        this.sessionContext.cleanup();
        this.singletonContext.cleanup();
        this.applicationContext.cleanup();
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AbstractApplicationContext getSingletonContext() {
        return this.singletonContext;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public DependentContext getDependentContext() {
        return this.dependentContext;
    }
}

