/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.introspector.jlr.AbstractWeldCallable;
import org.jboss.weld.introspector.jlr.ConstructorSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldParameterImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldConstructorImpl<T>
extends AbstractWeldCallable<T, T, Constructor<T>>
implements WeldConstructor<T> {
    private final Constructor<T> constructor;
    private final List<WeldParameter<?, T>> parameters;
    private final ListMultimap<Class<? extends Annotation>, WeldParameter<?, T>> annotatedParameters;
    private final ConstructorSignature signature;
    private final String toString;

    public static <T> WeldConstructor<T> of(Constructor<T> constructor, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(constructor, classTransformer.getTypeStore());
        return new WeldConstructorImpl<T>(Reflections.ensureAccessible(constructor), constructor.getDeclaringClass(), constructor.getDeclaringClass(), null, new Reflections.HierarchyDiscovery(constructor.getDeclaringClass()).getTypeClosure(), annotationStore, declaringClass, classTransformer);
    }

    public static <T> WeldConstructor<T> of(AnnotatedConstructor<T> annotatedConstructor, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedConstructor.getAnnotations(), annotatedConstructor.getAnnotations(), classTransformer.getTypeStore());
        return new WeldConstructorImpl(Reflections.ensureAccessible(annotatedConstructor.getJavaMember()), annotatedConstructor.getJavaMember().getDeclaringClass(), annotatedConstructor.getBaseType(), annotatedConstructor, annotatedConstructor.getTypeClosure(), annotationStore, declaringClass, classTransformer);
    }

    private WeldConstructorImpl(Constructor<T> constructor, Class<T> rawType, Type type, AnnotatedConstructor<T> annotatedConstructor, Set<Type> typeClosure, AnnotationStore annotationStore, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        super(annotationStore, constructor, rawType, type, typeClosure, declaringClass);
        this.toString = "constructor " + constructor.toString();
        this.constructor = constructor;
        this.parameters = new ArrayList();
        this.annotatedParameters = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<WeldParameter<?, T>>>(){

            public List<WeldParameter<?, T>> get() {
                return new ArrayList();
            }
        });
        HashMap<Integer, AnnotatedParameter> annotatedTypeParameters = new HashMap<Integer, AnnotatedParameter>();
        if (annotatedConstructor != null) {
            for (AnnotatedParameter annotated : annotatedConstructor.getParameters()) {
                annotatedTypeParameters.put(annotated.getPosition(), annotated);
            }
        }
        int nesting = Reflections.getNesting(declaringClass.getJavaClass());
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            WeldParameter parameter;
            Type parameterType;
            Class<?> clazz;
            int gi = i - nesting;
            if (constructor.getParameterAnnotations()[i].length > 0 || annotatedTypeParameters.containsKey(i)) {
                clazz = constructor.getParameterTypes()[i];
                parameterType = constructor.getGenericParameterTypes().length > gi && gi >= 0 ? constructor.getGenericParameterTypes()[gi] : clazz;
                parameter = null;
                if (annotatedTypeParameters.containsKey(i)) {
                    AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotatedTypeParameters.get(i);
                    parameter = WeldParameterImpl.of(annotatedParameter.getAnnotations(), clazz, parameterType, this, i, classTransformer);
                } else {
                    parameter = WeldParameterImpl.of(constructor.getParameterAnnotations()[i], clazz, parameterType, this, i, classTransformer);
                }
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = constructor.getParameterTypes()[i];
            parameterType = constructor.getGenericParameterTypes().length > gi && gi >= 0 ? constructor.getGenericParameterTypes()[gi] : clazz;
            parameter = WeldParameterImpl.of(new Annotation[0], clazz, parameterType, this, i, classTransformer);
            this.parameters.add(parameter);
            for (Annotation annotation : parameter.getAnnotations()) {
                this.annotatedParameters.put(annotation.annotationType(), parameter);
            }
        }
        this.signature = new ConstructorSignatureImpl(this);
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public List<WeldParameter<?, T>> getWeldParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<WeldParameter<?, T>> getAnnotatedWBParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public T newInstance(Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ((Constructor)this.getDelegate()).newInstance(parameters);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof WeldConstructor) {
            WeldConstructor that = (WeldConstructor)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && ((Object)this.getWeldParameters()).equals(that.getWeldParameters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Constructor)this.getDelegate()).hashCode();
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }

    public List<AnnotatedParameter<T>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }
}

