/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import ch.qos.cal10n.MessageConveyor;
import ch.qos.cal10n.MessageConveyorException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.jboss.weld.logging.MessageId;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldMessageConveyor
extends MessageConveyor {
    private static final String SEPARATOR = "-";
    private final String subsystem;
    private final ConcurrentCache<Enum<?>, String> messagePrefixCache;

    public WeldMessageConveyor(Locale locale, String subsystem) {
        super(locale);
        this.subsystem = subsystem;
        this.messagePrefixCache = new ConcurrentCache();
    }

    public <E extends Enum<?>> String getMessage(E key, Object ... args) throws MessageConveyorException {
        return this.getMessagePrefix(key) + super.getMessage(key, args);
    }

    private <E extends Enum<?>> String getMessagePrefix(final E key) {
        return this.messagePrefixCache.putIfAbsent(key, new Callable<String>(){

            @Override
            public String call() throws Exception {
                Field field = key.getClass().getField(key.name());
                if (!field.isAnnotationPresent(MessageId.class)) {
                    throw new IllegalArgumentException("@MessageId must be present. Key: " + key + "; Key Type: " + key.getClass());
                }
                String messageId = field.getAnnotation(MessageId.class).value();
                return WeldMessageConveyor.this.subsystem + WeldMessageConveyor.SEPARATOR + messageId + " ";
            }
        });
    }
}

