/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.metadata.cache.BindingTypeModel;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationStore
implements Service {
    private ConcurrentCache<Class<? extends Annotation>, StereotypeModel<?>> stereotypes = new ConcurrentCache();
    private ConcurrentCache<Class<? extends Annotation>, ScopeModel<?>> scopes = new ConcurrentCache();
    private ConcurrentCache<Class<? extends Annotation>, BindingTypeModel<?>> bindingTypes = new ConcurrentCache();
    private ConcurrentCache<Class<? extends Annotation>, InterceptorBindingModel<?>> interceptorBindings = new ConcurrentCache();
    private final ClassTransformer classTransformer;

    public MetaAnnotationStore(ClassTransformer classTransformer) {
        this.classTransformer = classTransformer;
    }

    public <T extends Annotation> StereotypeModel<T> getStereotype(final Class<T> stereotype) {
        return (StereotypeModel)this.stereotypes.putIfAbsent(stereotype, new Callable<StereotypeModel<T>>(){

            @Override
            public StereotypeModel<T> call() throws Exception {
                return new StereotypeModel(stereotype, MetaAnnotationStore.this.classTransformer);
            }
        });
    }

    public <T extends Annotation> ScopeModel<T> getScopeModel(final Class<T> scopeType) {
        return (ScopeModel)this.scopes.putIfAbsent(scopeType, new Callable<ScopeModel<T>>(){

            @Override
            public ScopeModel<T> call() throws Exception {
                return new ScopeModel(scopeType, MetaAnnotationStore.this.classTransformer);
            }
        });
    }

    public <T extends Annotation> BindingTypeModel<T> getBindingTypeModel(final Class<T> bindingType) {
        return (BindingTypeModel)this.bindingTypes.putIfAbsent(bindingType, new Callable<BindingTypeModel<T>>(){

            @Override
            public BindingTypeModel<T> call() throws Exception {
                return new BindingTypeModel(bindingType, MetaAnnotationStore.this.classTransformer);
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata cache\n");
        buffer.append("Registered binding type models: " + this.bindingTypes.size() + "\n");
        buffer.append("Registered scope type models: " + this.scopes.size() + "\n");
        buffer.append("Registered stereotype models: " + this.stereotypes.size() + "\n");
        buffer.append("Registered interceptor binding models: " + this.interceptorBindings.size() + "\n");
        return buffer.toString();
    }

    public void cleanup() {
        this.bindingTypes.clear();
        this.scopes.clear();
        this.stereotypes.clear();
        this.interceptorBindings.clear();
    }

    public <T extends Annotation> InterceptorBindingModel getInterceptorBindingModel(final Class<T> interceptorBinding) {
        return (InterceptorBindingModel)this.interceptorBindings.putIfAbsent(interceptorBinding, new Callable<InterceptorBindingModel<T>>(){

            @Override
            public InterceptorBindingModel<T> call() throws Exception {
                return new InterceptorBindingModel(interceptorBinding, MetaAnnotationStore.this.classTransformer);
            }
        });
    }
}

