/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.context.FacesContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.weld.conversation.ConversationIdName;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.ConversationManager;
import org.jboss.weld.jsf.FacesUrlTransformer;
import org.jboss.weld.servlet.ServletHelper;

public class ConversationPropagationFilter
implements Filter {
    private ServletContext ctx;

    public void init(FilterConfig config) throws ServletException {
        this.ctx = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            response = this.wrapResponse((HttpServletResponse)response, ((HttpServletRequest)request).getContextPath());
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private ServletResponse wrapResponse(HttpServletResponse response, String requestPath) {
        return new HttpServletResponseWrapper(response){

            public void sendRedirect(String path) throws IOException {
                ConversationImpl conversation = ServletHelper.getModuleBeanManager(ConversationPropagationFilter.this.ctx).getInstanceByType(ConversationImpl.class, new Annotation[0]);
                if (!conversation.isTransient()) {
                    String cidParamName = ServletHelper.getModuleBeanManager(ConversationPropagationFilter.this.ctx).getInstanceByType(String.class, new Annotation[]{new AnnotationLiteral<ConversationIdName>(){}});
                    path = new FacesUrlTransformer(path, FacesContext.getCurrentInstance()).toRedirectViewId().toActionUrl().appendConversationIdIfNecessary(conversation.getUnderlyingId()).encode();
                    ServletHelper.getModuleBeanManager(ConversationPropagationFilter.this.ctx).getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
                }
                super.sendRedirect(path);
            }
        };
    }
}

