/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.conversation.ConversationManager;
import org.jboss.weld.servlet.HttpRequestSessionBeanStore;
import org.jboss.weld.servlet.HttpSessionBeanStore;
import org.jboss.weld.servlet.HttpSessionManager;
import org.jboss.weld.servlet.ServletHelper;

public class ServletLifecycle {
    private final ContextLifecycle lifecycle;
    public static final String REQUEST_ATTRIBUTE_NAME = ServletLifecycle.class.getName() + ".requestBeanStore";

    public ServletLifecycle(ContextLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void beginSession(HttpSession session) {
    }

    public void endSession(HttpSession session) {
        ConversationManager conversationManager = ServletHelper.getModuleBeanManager(session.getServletContext()).getInstanceByType(ConversationManager.class, new Annotation[0]);
        if (this.lifecycle.getSessionContext().isActive()) {
            conversationManager.destroyAllConversations();
            this.lifecycle.endSession(session.getId(), this.lifecycle.getSessionContext().getBeanStore());
        } else if (this.lifecycle.getRequestContext().isActive()) {
            conversationManager.destroyAllConversations();
            this.lifecycle.endSession(session.getId(), this.restoreSessionContext(session));
        } else {
            ConcurrentHashMapBeanStore mockRequest = new ConcurrentHashMapBeanStore();
            this.lifecycle.beginRequest("endSession-" + session.getId(), (BeanStore)mockRequest);
            BeanStore sessionBeanStore = this.restoreSessionContext(session);
            conversationManager.destroyAllConversations();
            this.lifecycle.endSession(session.getId(), sessionBeanStore);
            this.lifecycle.endRequest("endSession-" + session.getId(), (BeanStore)mockRequest);
        }
    }

    protected BeanStore restoreSessionContext(HttpServletRequest request) {
        HttpRequestSessionBeanStore sessionBeanStore = new HttpRequestSessionBeanStore(request);
        HttpSession session = request.getSession(false);
        this.lifecycle.restoreSession(session == null ? "Inactive session" : session.getId(), sessionBeanStore);
        if (session != null) {
            ServletHelper.getModuleBeanManager(session.getServletContext()).getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        }
        return sessionBeanStore;
    }

    protected BeanStore restoreSessionContext(HttpSession session) {
        HttpSessionBeanStore beanStore = new HttpSessionBeanStore(session);
        this.lifecycle.restoreSession(session.getId(), beanStore);
        ServletHelper.getModuleBeanManager(session.getServletContext()).getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        return beanStore;
    }

    public void beginRequest(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) == null) {
            ConcurrentHashMapBeanStore beanStore = new ConcurrentHashMapBeanStore();
            request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)beanStore);
            this.lifecycle.beginRequest(request.getRequestURI(), (BeanStore)beanStore);
            this.restoreSessionContext(request);
        }
    }

    public void endRequest(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) != null) {
            BeanStore beanStore = (BeanStore)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
            if (beanStore == null) {
                throw new IllegalStateException("Cannot obtain request scoped beans from the request");
            }
            this.lifecycle.endRequest(request.getRequestURI(), beanStore);
            request.removeAttribute(REQUEST_ATTRIBUTE_NAME);
            this.lifecycle.getSessionContext().setActive(false);
            this.lifecycle.getSessionContext().setBeanStore(null);
        }
    }
}

