/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jboss.weld.util.Reflections;

public class Observers {
    public static void checkEventObjectType(Type eventType) {
        Type[] types;
        Type resolvedType = new Reflections.HierarchyDiscovery(eventType).getResolvedType();
        if (resolvedType instanceof Class) {
            types = new Type[]{};
        } else if (resolvedType instanceof ParameterizedType) {
            types = ((ParameterizedType)resolvedType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException("Event type " + resolvedType + " is not allowed");
        }
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot provide an event type parameterized with a type parameter " + resolvedType);
        }
    }

    public static void checkEventObjectType(Object event) {
        Observers.checkEventObjectType(event.getClass());
    }
}

