/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.metamodel.MetamodelImpl;
import org.hibernate.ejb.util.PersistenceUtilHelper;
import org.hibernate.engine.SessionFactoryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private final SessionFactory sessionFactory;
    private final PersistenceUnitTransactionType transactionType;
    private final boolean discardOnClose;
    private final Class sessionInterceptorClass;
    private final CriteriaBuilderImpl criteriaBuilder;
    private final Metamodel metamodel;
    private final HibernatePersistenceUnitUtil util;

    public EntityManagerFactoryImpl(SessionFactory sessionFactory, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class<?> sessionInterceptorClass, Configuration cfg) {
        this.sessionFactory = sessionFactory;
        this.transactionType = transactionType;
        this.discardOnClose = discardOnClose;
        this.sessionInterceptorClass = sessionInterceptorClass;
        Iterator classes = cfg.getClassMappings();
        this.metamodel = !"disabled".equalsIgnoreCase(cfg.getProperty("hibernate.ejb.metamodel.generation")) ? MetamodelImpl.buildMetamodel(classes, (SessionFactoryImplementor)sessionFactory) : null;
        this.criteriaBuilder = new CriteriaBuilderImpl(this);
        this.util = new HibernatePersistenceUnitUtil(this);
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(null);
    }

    public EntityManager createEntityManager(Map map) {
        return new EntityManagerImpl(this, PersistenceContextType.EXTENDED, this.transactionType, this.discardOnClose, this.sessionInterceptorClass, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Metamodel getMetamodel() {
        return this.metamodel;
    }

    public void close() {
        this.sessionFactory.close();
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public Set<String> getSupportedProperties() {
        return null;
    }

    public Cache getCache() {
        return new JPACache(this.sessionFactory);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return null;
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private static class HibernatePersistenceUnitUtil
    implements PersistenceUnitUtil,
    Serializable {
        private final EntityManagerFactoryImpl emf;

        private HibernatePersistenceUnitUtil(EntityManagerFactoryImpl emf) {
            this.emf = emf;
        }

        public boolean isLoaded(Object entity, String attributeName) {
            LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName);
            if (state == LoadState.LOADED) {
                return true;
            }
            if (state == LoadState.NOT_LOADED) {
                return false;
            }
            return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName) != LoadState.NOT_LOADED;
        }

        public boolean isLoaded(Object entity) {
            return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
        }

        public Object getIdentifier(Object entity) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private static class JPACache
    implements Cache {
        private SessionFactory sessionFactory;

        private JPACache(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public boolean contains(Class entityClass, Object identifier) {
            return this.sessionFactory.getCache().containsEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass, Object identifier) {
            this.sessionFactory.getCache().evictEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass) {
            this.sessionFactory.getCache().evictEntityRegion(entityClass);
        }

        public void evictAll() {
            this.sessionFactory.getCache().evictEntityRegions();
        }
    }
}

