/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.Collection;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.ejb.criteria.BasicPathUsageException;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.TableExpressionMapper;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathImpl<X>
extends ExpressionImpl<X>
implements Path<X> {
    private final PathImpl<?> origin;
    private final Attribute<?, ?> attribute;
    private Object model;

    protected PathImpl(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, PathImpl<?> origin, Attribute<?, ?> attribute, Object model) {
        super(criteriaBuilder, javaType);
        this.origin = origin;
        this.attribute = attribute;
        this.model = model;
    }

    public PathImpl<?> getParentPath() {
        return this.origin;
    }

    public Attribute<?, ?> getAttribute() {
        return this.attribute;
    }

    public Bindable<X> getModel() {
        if (this.model == null) {
            throw new IllegalStateException(this + " represents a basic path and not a bindable");
        }
        return (Bindable)this.model;
    }

    public Expression<Class<? extends X>> type() {
        throw new BasicPathUsageException("type() is not applicable to primitive paths.", this.getAttribute());
    }

    public <Y> Path<Y> get(SingularAttribute<? super X, Y> attribute) {
        throw this.illegalDereference();
    }

    private BasicPathUsageException illegalDereference() {
        return new BasicPathUsageException("Primitive path cannot be de-referenced", this.getAttribute());
    }

    public <E, C extends Collection<E>> Expression<C> get(PluralAttribute<X, C, E> collection) {
        throw this.illegalDereference();
    }

    public <K, V, M extends Map<K, V>> Expression<M> get(MapAttribute<X, K, V> map) {
        throw this.illegalDereference();
    }

    public <Y> Path<Y> get(String attributeName) {
        throw this.illegalDereference();
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    public String getPathIdentifier() {
        return this.getParentPath().getPathIdentifier() + "." + this.getAttribute().getName();
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        ((TableExpressionMapper)this.getParentPath()).prepareAlias(renderingContext);
        return this.getParentPath().getAlias() + '.' + this.getAttribute().getName();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

