/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.CriteriaSubqueryImpl;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.RootImpl;
import org.hibernate.ejb.criteria.TableExpressionMapper;
import org.hibernate.ejb.criteria.expression.ExpressionImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStructure<T> {
    private final AbstractQuery<T> owner;
    private final CriteriaBuilderImpl criteriaBuilder;
    private boolean distinct;
    private Selection<? extends T> selection;
    private Set<Root<?>> roots = new HashSet();
    private Predicate restriction;
    private List<Expression<?>> groupings = Collections.emptyList();
    private Predicate having;
    private List<Subquery<?>> subqueries;

    public QueryStructure(AbstractQuery<T> owner, CriteriaBuilderImpl criteriaBuilder) {
        this.owner = owner;
        this.criteriaBuilder = criteriaBuilder;
    }

    public Set<ParameterExpression<?>> getParameters() {
        final LinkedHashSet parameters = new LinkedHashSet();
        ParameterRegistry registry = new ParameterRegistry(){

            @Override
            public void registerParameter(ParameterExpression<?> parameter) {
                parameters.add(parameter);
            }
        };
        ParameterContainer.Helper.possibleParameter(this.selection, registry);
        ParameterContainer.Helper.possibleParameter((Selection)this.restriction, registry);
        ParameterContainer.Helper.possibleParameter((Selection)this.having, registry);
        if (this.subqueries != null) {
            for (Subquery<?> subquery : this.subqueries) {
                ParameterContainer.Helper.possibleParameter(subquery, registry);
            }
        }
        ParameterContainer.Helper.possibleParameter((Selection)this.having, registry);
        if (this.groupings != null) {
            for (Expression expression : this.groupings) {
                ParameterContainer.Helper.possibleParameter((Selection)expression, registry);
            }
        }
        return parameters;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Selection<? extends T> getSelection() {
        return this.selection;
    }

    public void setSelection(Selection<? extends T> selection) {
        this.selection = selection;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public <X> Root<X> from(Class<X> entityClass) {
        EntityType entityType = this.criteriaBuilder.getEntityManagerFactory().getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType);
    }

    public <X> Root<X> from(EntityType<X> entityType) {
        RootImpl<X> root = new RootImpl<X>(this.criteriaBuilder, entityType);
        this.roots.add(root);
        return root;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Predicate restriction) {
        this.restriction = restriction;
    }

    public List<Expression<?>> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(List<Expression<?>> groupings) {
        this.groupings = groupings;
    }

    public void setGroupings(Expression<?> ... groupings) {
        this.groupings = groupings != null && groupings.length > 0 ? Arrays.asList(groupings) : Collections.emptyList();
    }

    public Predicate getHaving() {
        return this.having;
    }

    public void setHaving(Predicate having) {
        this.having = having;
    }

    public List<Subquery<?>> getSubqueries() {
        return this.subqueries;
    }

    public List<Subquery<?>> internalGetSubqueries() {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        return this.subqueries;
    }

    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        CriteriaSubqueryImpl<U> subquery = new CriteriaSubqueryImpl<U>(this.criteriaBuilder, subqueryType, this.owner);
        this.internalGetSubqueries().add(subquery);
        return subquery;
    }

    public void render(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext) {
        jpaqlQuery.append("select ");
        if (this.isDistinct()) {
            jpaqlQuery.append(" distinct ");
        }
        if (this.getSelection() == null) {
            Root<?> root = this.getRoots().iterator().next();
            jpaqlQuery.append(((ExpressionImplementor)root).renderProjection(renderingContext));
        } else {
            jpaqlQuery.append(((ExpressionImplementor)this.getSelection()).renderProjection(renderingContext));
        }
        jpaqlQuery.append(" from ");
        String sep = "";
        for (Root<?> root : this.getRoots()) {
            ((TableExpressionMapper)root).prepareAlias(renderingContext);
            jpaqlQuery.append(sep);
            jpaqlQuery.append(((TableExpressionMapper)root).renderTableExpression(renderingContext));
            sep = ", ";
        }
        for (Root<?> root : this.getRoots()) {
            this.renderJoins(jpaqlQuery, renderingContext, root.getJoins());
            this.renderFetches(jpaqlQuery, renderingContext, root.getFetches());
        }
        if (this.getRestriction() != null) {
            jpaqlQuery.append(" where ").append(((ExpressionImplementor)this.getRestriction()).render(renderingContext));
        }
        if (!this.getGroupings().isEmpty()) {
            jpaqlQuery.append(" group by ");
            sep = "";
            for (Expression expression : this.getGroupings()) {
                jpaqlQuery.append(sep).append(((ExpressionImplementor)expression).render(renderingContext));
                sep = ", ";
            }
            if (this.getHaving() != null) {
                jpaqlQuery.append(" having ").append(((ExpressionImplementor)this.getHaving()).render(renderingContext));
            }
        }
    }

    private void renderJoins(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext, Collection<Join<?, ?>> joins) {
        if (joins == null) {
            return;
        }
        for (Join<?, ?> join : joins) {
            ((TableExpressionMapper)join).prepareAlias(renderingContext);
            jpaqlQuery.append(this.renderJoinType(join.getJoinType())).append(((TableExpressionMapper)join).renderTableExpression(renderingContext));
            this.renderJoins(jpaqlQuery, renderingContext, join.getJoins());
            this.renderFetches(jpaqlQuery, renderingContext, join.getFetches());
        }
    }

    private String renderJoinType(JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return " inner join ";
            }
            case LEFT: {
                return " left join ";
            }
            case RIGHT: {
                return " right join ";
            }
        }
        throw new IllegalStateException("Unknown join type " + joinType);
    }

    private void renderFetches(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext, Collection<Fetch> fetches) {
        if (fetches == null) {
            return;
        }
        for (Fetch fetch : fetches) {
            ((TableExpressionMapper)fetch).prepareAlias(renderingContext);
            jpaqlQuery.append(this.renderJoinType(fetch.getJoinType())).append("fetch ").append(((TableExpressionMapper)fetch).renderTableExpression(renderingContext));
            this.renderFetches(jpaqlQuery, renderingContext, fetch.getFetches());
        }
    }
}

