/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import javax.persistence.metamodel.PluralAttribute;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.PathImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExpression<C>
extends ExpressionImpl<C> {
    private final PathImpl origin;
    private final CollectionPersister persister;
    private final PluralAttribute<?, C, ?> attribute;

    public CollectionExpression(CriteriaBuilderImpl criteriaBuilder, Class<C> javaType, PathImpl origin, PluralAttribute<?, C, ?> attribute) {
        this(criteriaBuilder, javaType, CollectionExpression.resolvePersister(criteriaBuilder, attribute), origin, attribute);
    }

    private static CollectionPersister resolvePersister(CriteriaBuilderImpl criteriaBuilder, PluralAttribute attribute) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)criteriaBuilder.getEntityManagerFactory().getSessionFactory();
        return sfi.getCollectionPersister(CollectionExpression.resolveRole(attribute));
    }

    private static String resolveRole(PluralAttribute attribute) {
        return attribute.getDeclaringType().getJavaType().getName() + '.' + attribute.getName();
    }

    public CollectionExpression(CriteriaBuilderImpl criteriaBuilder, Class<C> javaType, CollectionPersister persister, PathImpl origin, PluralAttribute<?, C, ?> attribute) {
        super(criteriaBuilder, javaType);
        this.origin = origin;
        this.persister = persister;
        this.attribute = attribute;
    }

    public PluralAttribute<?, C, ?> getAttribute() {
        return this.attribute;
    }

    public CollectionPersister getPersister() {
        return this.persister;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.origin.getPathIdentifier() + '.' + this.getAttribute().getName();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

