/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.ExpressionImplementor;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikePredicate
extends AbstractSimplePredicate {
    private final Expression<String> matchExpression;
    private final Expression<String> pattern;
    private final Expression<Character> escapeCharacter;

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, Expression<String> pattern) {
        this(criteriaBuilder, matchExpression, pattern, null);
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, String pattern) {
        this(criteriaBuilder, matchExpression, new LiteralExpression<String>(criteriaBuilder, pattern));
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        super(criteriaBuilder);
        this.matchExpression = matchExpression;
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, Expression<String> pattern, char escapeCharacter) {
        this(criteriaBuilder, matchExpression, pattern, new LiteralExpression<Character>(criteriaBuilder, Character.valueOf(escapeCharacter)));
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, String pattern, char escapeCharacter) {
        this(criteriaBuilder, matchExpression, new LiteralExpression<String>(criteriaBuilder, pattern), new LiteralExpression<Character>(criteriaBuilder, Character.valueOf(escapeCharacter)));
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, String pattern, Expression<Character> escapeCharacter) {
        this(criteriaBuilder, matchExpression, new LiteralExpression<String>(criteriaBuilder, pattern), escapeCharacter);
    }

    public Expression<Character> getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public Expression<String> getMatchExpression() {
        return this.matchExpression;
    }

    public Expression<String> getPattern() {
        return this.pattern;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getEscapeCharacter(), registry);
        ParameterContainer.Helper.possibleParameter(this.getMatchExpression(), registry);
        ParameterContainer.Helper.possibleParameter(this.getPattern(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        StringBuilder likeExpr = new StringBuilder();
        likeExpr.append(((ExpressionImplementor)this.getMatchExpression()).render(renderingContext)).append(" like ").append(((ExpressionImplementor)this.getPattern()).render(renderingContext));
        if (this.escapeCharacter != null) {
            likeExpr.append(" escape ").append(((ExpressionImplementor)this.getEscapeCharacter()).render(renderingContext));
        }
        return likeExpr.toString();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

